var orderItemBookingDetails={template:`<div v-if="data.booking_status === 'canceled'" class="order-event"><div class="order-event-icon vx-red"><icon-calendar/></div><b>{{ data.type === 'timeslots' ? data.l10n.appt_canceled : data.l10n.booking_canceled }}</b></div><div v-else class="order-event"><div class="order-event-icon vx-blue"><icon-calendar/></div><b>{{ data.type === 'timeslots' ? data.l10n.appt_confirmed : data.l10n.booking_confirmed }}</b> <span>{{ data.summary }}</span><div class="further-actions"><template v-for="action, action_type in data.actions"><template v-if="action_type === 'add_to_gcal' && (
						( parent.isCustomer() && action.enabled_for_customer )
						|| ( parent.isVendor() && action.enabled_for_vendor )
						|| ( parent.isAdmin() && action.enabled_for_vendor )
					)"><a :href="action.link" target="_blank" class="ts-btn ts-btn-1">{{ data.l10n.add_to_gcal }}</a></template><template v-if="action_type === 'add_to_ical' && (
						( parent.isCustomer() && action.enabled_for_customer )
						|| ( parent.isVendor() && action.enabled_for_vendor )
						|| ( parent.isAdmin() && action.enabled_for_vendor )
					)"><a :href="action.link" :download="action.filename" role="button" target="_blank" class="ts-btn ts-btn-1">{{ data.l10n.add_to_ical }}</a></template><template v-if="action_type === 'cancel' && (
						( parent.isCustomer() && action.enabled_for_customer )
						|| ( parent.isVendor() && action.enabled_for_vendor )
					)"><a href="#" @click.prevent="cancelBooking" target="_blank" class="ts-btn ts-btn-1">{{ data.l10n.cancel_booking }}</a></template><template v-if="action_type === 'reschedule' && data.schedule !== null && (
						( parent.isCustomer() && action.enabled_for_customer )
						|| ( parent.isVendor() && action.enabled_for_vendor )
					)"><form-group :popup-key="'booking-reschedule-'+order.id" wrapper-class="lg-width xl-height" ref="bookingCalendar" @save="confirmReschedule" @blur="blurReschedule" @clear="clearReschedule" :clear-label="data.l10n.cancel_reschedule" :save-label="data.l10n.reschedule"><template #trigger><a href="#" @click.prevent="openCalendar" target="_blank" class="ts-popup-target ts-btn ts-btn-1">{{ data.l10n.reschedule }}</a></template><template #popup><div class="ts-booking-date ts-booking-date-single ts-form-group" ref="calendar"><input type="hidden" ref="calendarInput"></div><div v-if="data.type === 'timeslots' && reschedule.timeslots.date" class="ts-form-group"><label>{{ data.l10n.time }}</label><div class="ts-filter"><select v-model="reschedule.timeslots.slot"><option :value="null">{{ data.l10n.pick_time }}</option><option v-for="s in currentDaySlots" :disabled="s._disabled" :value="s">{{ getSlotLabel(s) }}</option></select></div></div></template></form-group></template></template></div></div>`,props:{orderItem:Object,parent:Object,order:Object,data:Object},data(){return{picker:null,reschedule:{weekdays:["sun","mon","tue","wed","thu","fri","sat"],single_day:{date:null},timeslots:{date:null,slot:null,schedule:{}}}}},methods:{cancelBooking(){Voxel.prompt(Voxel_Config.l10n.confirmAction,"warning",[{label:Voxel_Config.l10n.yes,onClick:()=>{this.parent.running_action=!0,jQuery.post(Voxel_Config.ajax_url+"&action=products.single_order.bookings.cancel_booking",{order_id:this.order.id,order_item_id:this.orderItem.id,_wpnonce:this.parent.orders.config.nonce}).always(e=>{this.parent.running_action=!1,e.success||Voxel.alert(e.message||Voxel_Config.l10n.ajaxError,"error"),this.parent.reload()})}},{label:Voxel_Config.l10n.no,onClick:()=>{}}],7500)},openCalendar(){this.$root.activePopup="booking-reschedule-"+this.order.id,this.picker?.destroy(),this.$nextTick(()=>{this.renderPicker(),document.body.dispatchEvent(new CustomEvent("scroll"))})},dateFormat(e){return Voxel.helpers.dateFormat(e)},_getBufferTime(){var e=this.data.schedule.availability.buffer;return"hours"===e.unit?36e5*e.amount:864e5*e.amount},renderPicker(){let t=this.data.schedule;var e=new Date(t.today.date+"T"+t.today.time+"Z"),a=new Date(e.getTime()+this._getBufferTime()),e=new Date(e.getTime()+864e5*(t.availability.max_days-1));a.setHours(0,0,0,0),e.setHours(0,0,0,0),"timeslots"===this.data.type?(t.timeslots.groups.forEach(t=>{t.days.forEach(e=>{this.reschedule.timeslots.schedule[e]=t.slots})}),this.picker=new Pikaday({field:this.$refs.calendarInput?.[0],container:this.$refs.calendar?.[0],bound:!1,firstDay:1,keyboardInput:!1,numberOfMonths:1,minDate:a,maxDate:e,expandYears:!1,onSelect:e=>{this.reschedule.timeslots.date=e,this.reschedule.timeslots.slot=null},selectDayFn:e=>this.reschedule.timeslots.date&&this.reschedule.timeslots.date.toDateString()===e.toDateString(),disableDayFn:e=>{e=this.reschedule.timeslots.schedule[this.reschedule.weekdays[e.getDay()]];if(!Array.isArray(e)||!e.length)return!0},unavailableDayFn:e=>{if(t.excluded_days.includes(Voxel.helpers.dateFormatYmd(e)))return!0}})):this.picker=new Pikaday({field:this.$refs.calendarInput?.[0],container:this.$refs.calendar?.[0],bound:!1,firstDay:1,keyboardInput:!1,numberOfMonths:1,minDate:a,maxDate:e,expandYears:!1,onSelect:e=>{this.reschedule.single_day.date=e},selectDayFn:e=>this.reschedule.single_day.date&&this.reschedule.single_day.date.toDateString()===e.toDateString(),disableDayFn:e=>{e=this.reschedule.weekdays[e.getDay()];if(t.excluded_weekdays.includes(e))return!0},unavailableDayFn:e=>{if(t.excluded_days.includes(Voxel.helpers.dateFormatYmd(e)))return!0}})},confirmReschedule(){this.parent.running_action=!0;let e={};e="timeslots"===this.data.type?{date:this.reschedule.timeslots.date?Voxel.helpers.dateFormatYmd(this.reschedule.timeslots.date):null,slot:{from:this.reschedule.timeslots.slot?.from||null,to:this.reschedule.timeslots.slot?.to||null}}:{date:this.reschedule.single_day.date?Voxel.helpers.dateFormatYmd(this.reschedule.single_day.date):null},jQuery.post(Voxel_Config.ajax_url+"&action=products.single_order.bookings.reschedule_booking",{order_id:this.order.id,order_item_id:this.orderItem.id,reschedule_to:e,_wpnonce:this.parent.orders.config.nonce}).always(e=>{this.parent.running_action=!1,e.success?(this.clearReschedule(),this.parent.reload()):Voxel.alert(e.message||Voxel_Config.l10n.ajaxError,"error")})},blurReschedule(){this.reschedule.single_day={date:null},this.reschedule.timeslots={date:null,slot:null,schedule:{}}},clearReschedule(){this.blurReschedule(),this.$refs.bookingCalendar?.[0]?.blur()},getSlotLabel(e){return Voxel.helpers.timeFormat(new Date(`2020-01-01T${e.from}:00`))+" - "+Voxel.helpers.timeFormat(new Date(`2020-01-01T${e.to}:00`))}},computed:{currentDaySlots(){if("timeslots"!==this.data.type)return[];var e=this.data.schedule;let a=this.reschedule.timeslots.date;if(!a)return[];var t=new Date(e.today.date+"T"+e.today.time+"Z"),s=this.reschedule.timeslots.schedule[this.reschedule.weekdays[a.getDay()]];if(s.forEach(e=>e._disabled=!1),Voxel.helpers.dateFormatYmd(a)===Voxel.helpers.dateFormatYmd(t)){t=new Date(t.getTime()+this._getBufferTime());let a=parseInt(""+t.getUTCHours()+t.getUTCMinutes(),10);s.forEach(e=>{var t=e.from.split(":"),t=parseInt(""+t[0]+t[1],10);e._disabled=t<a})}let l=e.quantity_per_slot,r=e.booked_slot_counts;return s.forEach(e=>{var t=`${Voxel.helpers.dateFormatYmd(a)} ${e.from}-`+e.to;l-(r[t]||0)<1&&(e._disabled=!0)}),s}}};export{orderItemBookingDetails as default};
