<?php

// File generated from our OpenAPI spec
namespace Voxel\Vendor\Stripe\Events;

/**
 * @property \Stripe\RelatedObject $related_object Object containing the reference to API resource relevant to the event
 */
class V2CoreEventDestinationPingEvent extends \Voxel\Vendor\Stripe\V2\Event
{
    const LOOKUP_TYPE = 'v2.core.event_destination.ping';
    /**
     * Retrieves the related object from the API. Make an API request on every call.
     *
     * @return \Stripe\V2\EventDestination
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function fetchRelatedObject()
    {
        $apiMode = \Voxel\Vendor\Stripe\Util\Util::getApiMode($this->related_object->url);
        list($object, $options) = $this->_request('get', $this->related_object->url, [], ['stripe_account' => $this->context], [], $apiMode);
        return \Voxel\Vendor\Stripe\Util\Util::convertToStripeObject($object, $options, $apiMode);
    }
}
