<?php

namespace Voxel\Modules\Paid_Memberships\Controllers\Backend;

use \Voxel\Modules\Paid_Memberships as Module;
use \Voxel\Product_Types\Payment_Services\Base_Payment_Service as Payment_Service;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Member_Controller extends \Voxel\Controllers\Base_Controller {

	protected function authorize() {
		return current_user_can( 'manage_options' );
	}

	protected function hooks() {
		$this->on( 'voxel_ajax_membership.update_customer_plan', '@update_customer_plan' );
	}

	protected function update_customer_plan() {
		try {
			if ( ( $_SERVER['REQUEST_METHOD'] ?? null ) !== 'POST' ) {
				throw new \Exception( __( 'Invalid request.', 'voxel-backend' ), 100 );
			}

			if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'] ?? '', 'vx_admin_edit_customer' )  ) {
				throw new \Exception( __( 'Invalid request.', 'voxel-backend' ), 102 );
			}

			$payload = (array) json_decode( wp_unslash( $_REQUEST['payload'] ?? '' ), true );

			$user = \Voxel\User::get( $payload['customer_id'] ?? null );
			if ( ! $user ) {
				throw new \Exception( __( 'Invalid request.', 'voxel-backend' ), 103 );
			}

			$membership = $user->get_membership();

			$new_plan = Module\Plan::get( $payload['plan'] ?? null );
			if ( ! $new_plan ) {
				throw new \Exception( __( 'Invalid request.', 'voxel-backend' ), 104 );
			}

			if ( $membership->get_type() === 'order' ) {
				if (
					( $order = $membership->get_order() )
					&& ( $payment_method = $membership->get_payment_method() )
					&& ! $payment_method->is_subscription_canceled()
				) {
					// update order item meta
					foreach ( $order->get_items() as $order_item ) {
						if ( $order_item->get_product_field_key() === 'voxel:membership_plan' ) {
							$order_item->set_details( 'voxel:membership.plan', $new_plan->get_key() );
							$order_item->save();
						}
					}

					// update user meta
					$meta_key = \Voxel\is_test_mode() ? 'voxel:test_plan' : 'voxel:plan';

					$details = (array) json_decode( \Voxel\get_site_specific_user_meta( $user->get_id(), $meta_key, true ), true );
					$details['plan'] = $new_plan->get_key();

					Module\update_user_plan( $user->get_id(), $details );

					return wp_send_json( [
						'success' => true,
					] );
				} else {
					// unlink order (subscription cancelled permanently)
					Module\update_user_plan( $user->get_id(), [
						'plan' => 'default',
						'type' => 'default',
					] );

					return wp_send_json( [
						'success' => true,
					] );
				}
			} else {
				// manually assign plan
				$details = [
					'plan' => $new_plan->get_key(),
					'type' => 'default',
				];

				if ( $new_plan->get_key() === 'default' && ( $payload['trial_allowed'] ?? null ) ) {
					$details['trial_allowed'] = true;
				}

				Module\update_user_plan( $user->get_id(), $details );

				return wp_send_json( [
					'success' => true,
				] );
			}
		} catch ( \Exception $e ) {
			return wp_send_json( [
				'success' => false,
				'message' => $e->getMessage(),
			] );
		}
	}

}
