<?php

namespace Voxel\Modules\Claim_Listings\Controllers;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Claim_Listings_Controller extends \Voxel\Controllers\Base_Controller {

	protected function dependencies() {
		new Frontend\Claim_Checkout_Controller;
		new Frontend\Claim_Order_Controller;
	}

	protected function hooks() {
		$this->filter( 'voxel/product_types/get/voxel:claim', '@register_product_type' );
		$this->filter( 'voxel/post/get_field/voxel:claim', '@register_product_field', 10, 3 );
		$this->filter( 'voxel/advanced-list/actions', '@register_claim_action' );
		$this->on( 'voxel/advanced-list/action:claim_post', '@render_claim_action', 10, 2 );
	}

	protected function register_product_type() {
		return \Voxel\Product_Type::from( [
			'settings' => [
				'key' => 'voxel:claim',
				'label' => 'Voxel: Claim package',
				'product_mode' => 'regular',
				'payments' => [
					'mode' => \Voxel\get( 'product_settings.claims.payments.mode', 'payment' ) === 'offline' ? 'offline' : 'payment',
				],
				'supports_marketplace' => false,
			],
			'modules' => [
				'base_price' => [
					'enabled' => true,
					'discount_price' => [
						'enabled' => false,
					],
				],
				'cart' => [
					'enabled' => false,
				],
			],
		] );
	}

	protected function register_product_field( $field, $post, $post_type ) {
		$field = new \Voxel\Post_Types\Fields\Product_Field( [
			'label' => 'Claim post',
			'key' => 'voxel:claim',
			'product-types' => [ 'voxel:claim' ],
		] );

		$field->set_post( $post );
		$field->_set_value( [
			'product_type' => 'voxel:claim',
			'enabled' => $post->is_claimable(),
			'base_price' => [
				'amount' => $post->get_claim_price(),
			],
		] );

		return $field;
	}

	protected function register_claim_action( $actions ) {
		$actions['claim_post'] = __( 'Claim post', 'voxel-elementor' );
		return $actions;
	}

	protected function render_claim_action( $widget, $action ) {
		require locate_template( 'app/modules/claim-listings/templates/frontend/claim-post-action.php' );
	}

}
