<?php

namespace Voxel\Modules\Claim_Listings;

if ( ! defined('ABSPATH') ) {
	exit;
}

// new Controllers\Claim_Listings_Controller;

function get_proof_of_ownership_field() {
	return new \Voxel\Utils\Object_Fields\File_Field( [
		'label' => 'Proof of ownership',
		'key' => 'proof_of_ownership',
		'allowed-types' => apply_filters( 'voxel/claim_requests/proof_of_ownership/allowed_file_types', [
			'image/png',
			'image/jpeg',
			'image/webp',
			'application/pdf',
			'application/msword', // .doc
			'application/vnd.openxmlformats-officedocument.wordprocessingml.document', // .docx
		] ),
		'max-size' => apply_filters( 'voxel/claim_requests/proof_of_ownership/max_file_size', 2000 ),
		'max-count' => apply_filters( 'voxel/claim_requests/proof_of_ownership/max_file_count', 1 ),
		'private_upload' => true,
	] );
}
