import SvgIcon from '@elementor/ui/SvgIcon';

const AccessibilityAssistantDashboardIcon = (props) => {
	return (
		<SvgIcon
			width="237"
			height="157"
			viewBox="0 0 237 157"
			sx={{ fontSize: 237, height: 'auto' }}
			fill="none"
			{...props}
		>
			<path
				d="M143.574 87.6549L143.982 87.7017L144.151 88.8586C144.192 89.1093 144.215 89.3534 144.234 89.5878L144.248 89.5893C144.32 89.3655 144.421 89.1356 144.526 88.9063L145.022 87.8212L145.356 87.8596L145.573 89.0079C145.621 89.2735 145.663 89.5197 145.687 89.7545L145.7 89.7561C145.763 89.5312 145.85 89.3044 145.953 89.0516L146.397 87.979L146.795 88.0248L145.822 90.1554L145.455 90.1133L145.242 89.0164C145.193 88.76 145.154 88.5327 145.129 88.2652L145.12 88.2641C145.034 88.5236 144.939 88.7494 144.834 88.9742L144.355 89.987L143.989 89.9449L143.574 87.6549ZM147.002 88.0485L147.41 88.0953L147.578 89.2521C147.619 89.5029 147.642 89.747 147.662 89.9813L147.676 89.9829C147.748 89.7591 147.848 89.5292 147.954 89.2999L148.45 88.2147L148.784 88.2531L149.001 89.4015C149.049 89.6671 149.09 89.9132 149.114 90.1481L149.128 90.1497C149.191 89.9248 149.278 89.6979 149.381 89.4452L149.824 88.3726L150.223 88.4183L149.249 90.549L148.883 90.5069L148.67 89.41C148.62 89.1536 148.582 88.9263 148.557 88.6588L148.547 88.6577C148.462 88.9172 148.366 89.143 148.262 89.3677L147.783 90.3806L147.417 90.3385L147.002 88.0485ZM150.429 88.442L150.837 88.4889L151.006 89.6457C151.047 89.8965 151.07 90.1405 151.09 90.3749L151.103 90.3765C151.175 90.1526 151.276 89.9228 151.381 89.6934L151.877 88.6083L152.212 88.6467L152.428 89.7951C152.477 90.0606 152.518 90.3068 152.542 90.5417L152.556 90.5433C152.619 90.3184 152.705 90.0915 152.809 89.8387L153.252 88.7661L153.651 88.8119L152.677 90.9425L152.311 90.9004L152.098 89.8035C152.048 89.5472 152.009 89.3198 151.984 89.0523L151.975 89.0513C151.89 89.3107 151.794 89.5365 151.689 89.7613L151.211 90.7742L150.844 90.7321L150.429 88.442Z"
				fill="#F1F3F3"
			/>
			<path
				d="M143.574 87.6549L143.631 87.1582L142.962 87.0813L143.082 87.744L143.574 87.6549ZM143.982 87.7017L144.477 87.6295L144.421 87.2489L144.039 87.205L143.982 87.7017ZM144.151 88.8586L143.656 88.9308L143.657 88.939L144.151 88.8586ZM144.234 89.5878L143.736 89.6293L143.77 90.0377L144.177 90.0845L144.234 89.5878ZM144.248 89.5893L144.191 90.0861L144.598 90.1328L144.724 89.7427L144.248 89.5893ZM144.526 88.9063L144.98 89.1149L144.981 89.1142L144.526 88.9063ZM145.022 87.8212L145.079 87.3244L144.718 87.283L144.567 87.6133L145.022 87.8212ZM145.356 87.8596L145.848 87.767L145.78 87.4049L145.414 87.3628L145.356 87.8596ZM145.573 89.0079L146.065 88.9182L146.064 88.9154L145.573 89.0079ZM145.687 89.7545L145.189 89.8056L145.23 90.2054L145.63 90.2513L145.687 89.7545ZM145.7 89.7561L145.643 90.2529L146.067 90.3015L146.182 89.8909L145.7 89.7561ZM145.953 89.0516L145.491 88.8605L145.49 88.8624L145.953 89.0516ZM146.397 87.979L146.454 87.4823L146.079 87.4392L145.935 87.788L146.397 87.979ZM146.795 88.0248L147.25 88.2326L147.536 87.6066L146.852 87.528L146.795 88.0248ZM145.822 90.1554L145.765 90.6521L146.126 90.6936L146.277 90.3632L145.822 90.1554ZM145.455 90.1133L144.964 90.2086L145.034 90.5682L145.398 90.61L145.455 90.1133ZM145.242 89.0164L144.751 89.1112L144.751 89.1117L145.242 89.0164ZM145.129 88.2652L145.627 88.2187L145.589 87.8147L145.186 87.7685L145.129 88.2652ZM145.12 88.2641L145.177 87.7674L144.772 87.721L144.645 88.1077L145.12 88.2641ZM144.834 88.9742L145.286 89.1877L145.287 89.1853L144.834 88.9742ZM144.355 89.987L144.298 90.4838L144.654 90.5247L144.808 90.2006L144.355 89.987ZM143.989 89.9449L143.497 90.0341L143.563 90.3993L143.932 90.4417L143.989 89.9449ZM143.574 87.6549L143.517 88.1516L143.925 88.1985L143.982 87.7017L144.039 87.205L143.631 87.1582L143.574 87.6549ZM143.982 87.7017L143.487 87.774L143.656 88.9308L144.151 88.8586L144.645 88.7863L144.477 87.6295L143.982 87.7017ZM144.151 88.8586L143.657 88.939C143.695 89.1695 143.717 89.3975 143.736 89.6293L144.234 89.5878L144.732 89.5463C144.713 89.3092 144.688 89.0491 144.644 88.7782L144.151 88.8586ZM144.234 89.5878L144.177 90.0845L144.191 90.0861L144.248 89.5893L144.305 89.0926L144.291 89.091L144.234 89.5878ZM144.248 89.5893L144.724 89.7427C144.786 89.5491 144.876 89.3423 144.98 89.1149L144.526 88.9063L144.072 88.6977C143.965 88.929 143.854 89.1818 143.772 89.436L144.248 89.5893ZM144.526 88.9063L144.981 89.1142L145.477 88.029L145.022 87.8212L144.567 87.6133L144.071 88.6984L144.526 88.9063ZM145.022 87.8212L144.965 88.3179L145.299 88.3563L145.356 87.8596L145.414 87.3628L145.079 87.3244L145.022 87.8212ZM145.356 87.8596L144.865 87.9521L145.081 89.1005L145.573 89.0079L146.064 88.9154L145.848 87.767L145.356 87.8596ZM145.573 89.0079L145.081 89.0976C145.129 89.3611 145.167 89.5912 145.189 89.8056L145.687 89.7545L146.184 89.7035C146.158 89.4481 146.114 89.1859 146.065 88.9182L145.573 89.0079ZM145.687 89.7545L145.63 90.2513L145.643 90.2529L145.7 89.7561L145.758 89.2594L145.744 89.2578L145.687 89.7545ZM145.7 89.7561L146.182 89.8909C146.237 89.6945 146.314 89.4892 146.416 89.2408L145.953 89.0516L145.49 88.8624C145.385 89.1196 145.29 89.3679 145.219 89.6213L145.7 89.7561ZM145.953 89.0516L146.415 89.2427L146.859 88.1701L146.397 87.979L145.935 87.788L145.491 88.8605L145.953 89.0516ZM146.397 87.979L146.34 88.4757L146.738 88.5215L146.795 88.0248L146.852 87.528L146.454 87.4823L146.397 87.979ZM146.795 88.0248L146.341 87.817L145.367 89.9476L145.822 90.1554L146.277 90.3632L147.25 88.2326L146.795 88.0248ZM145.822 90.1554L145.879 89.6587L145.512 89.6166L145.455 90.1133L145.398 90.61L145.765 90.6521L145.822 90.1554ZM145.455 90.1133L145.946 90.018L145.733 88.9211L145.242 89.0164L144.751 89.1117L144.964 90.2086L145.455 90.1133ZM145.242 89.0164L145.733 88.9216C145.685 88.672 145.649 88.4628 145.627 88.2187L145.129 88.2652L144.631 88.3117C144.658 88.6026 144.7 88.848 144.751 89.1112L145.242 89.0164ZM145.129 88.2652L145.186 87.7685L145.177 87.7674L145.12 88.2641L145.063 88.7609L145.072 88.7619L145.129 88.2652ZM145.12 88.2641L144.645 88.1077C144.567 88.3428 144.48 88.5496 144.381 88.763L144.834 88.9742L145.287 89.1853C145.397 88.9492 145.501 88.7044 145.595 88.4206L145.12 88.2641ZM144.834 88.9742L144.382 88.7606L143.903 89.7735L144.355 89.987L144.808 90.2006L145.286 89.1877L144.834 88.9742ZM144.355 89.987L144.412 89.4903L144.046 89.4482L143.989 89.9449L143.932 90.4417L144.298 90.4838L144.355 89.987ZM143.989 89.9449L144.481 89.8558L144.066 87.5658L143.574 87.6549L143.082 87.744L143.497 90.0341L143.989 89.9449ZM147.002 88.0485L147.059 87.5517L146.39 87.4749L146.51 88.1376L147.002 88.0485ZM147.41 88.0953L147.904 88.023L147.849 87.6424L147.467 87.5986L147.41 88.0953ZM147.578 89.2521L147.084 89.3244L147.085 89.3325L147.578 89.2521ZM147.662 89.9813L147.164 90.0228L147.198 90.4313L147.605 90.4781L147.662 89.9813ZM147.676 89.9829L147.619 90.4797L148.026 90.5264L148.152 90.1363L147.676 89.9829ZM147.954 89.2999L148.408 89.5084L148.408 89.5077L147.954 89.2999ZM148.45 88.2147L148.507 87.718L148.146 87.6766L147.995 88.0069L148.45 88.2147ZM148.784 88.2531L149.276 88.1606L149.207 87.7984L148.841 87.7564L148.784 88.2531ZM149.001 89.4015L149.492 89.3118L149.492 89.3089L149.001 89.4015ZM149.114 90.1481L148.617 90.1991L148.658 90.599L149.057 90.6449L149.114 90.1481ZM149.128 90.1497L149.071 90.6464L149.495 90.6951L149.61 90.2845L149.128 90.1497ZM149.381 89.4452L148.919 89.2541L148.918 89.256L149.381 89.4452ZM149.824 88.3726L149.881 87.8758L149.507 87.8328L149.362 88.1815L149.824 88.3726ZM150.223 88.4183L150.678 88.6261L150.964 88.0001L150.28 87.9216L150.223 88.4183ZM149.249 90.549L149.192 91.0457L149.553 91.0871L149.704 90.7568L149.249 90.549ZM148.883 90.5069L148.392 90.6022L148.462 90.9618L148.826 91.0036L148.883 90.5069ZM148.67 89.41L148.179 89.5047L148.179 89.5053L148.67 89.41ZM148.557 88.6588L149.054 88.6122L149.017 88.2083L148.614 88.162L148.557 88.6588ZM148.547 88.6577L148.604 88.161L148.2 88.1145L148.073 88.5012L148.547 88.6577ZM148.262 89.3677L148.714 89.5813L148.715 89.5789L148.262 89.3677ZM147.783 90.3806L147.726 90.8773L148.082 90.9182L148.235 90.5942L147.783 90.3806ZM147.417 90.3385L146.925 90.4276L146.991 90.7929L147.36 90.8352L147.417 90.3385ZM147.002 88.0485L146.945 88.5452L147.352 88.592L147.41 88.0953L147.467 87.5986L147.059 87.5517L147.002 88.0485ZM147.41 88.0953L146.915 88.1676L147.084 89.3244L147.578 89.2521L148.073 89.1799L147.904 88.023L147.41 88.0953ZM147.578 89.2521L147.085 89.3325C147.123 89.5631 147.144 89.7911 147.164 90.0228L147.662 89.9813L148.16 89.9398C148.14 89.7028 148.116 89.4427 148.072 89.1718L147.578 89.2521ZM147.662 89.9813L147.605 90.4781L147.619 90.4797L147.676 89.9829L147.733 89.4862L147.719 89.4846L147.662 89.9813ZM147.676 89.9829L148.152 90.1363C148.214 89.9427 148.304 89.7358 148.408 89.5084L147.954 89.2999L147.499 89.0913C147.393 89.3226 147.282 89.5754 147.2 89.8296L147.676 89.9829ZM147.954 89.2999L148.408 89.5077L148.904 88.4226L148.45 88.2147L147.995 88.0069L147.499 89.092L147.954 89.2999ZM148.45 88.2147L148.393 88.7115L148.727 88.7499L148.784 88.2531L148.841 87.7564L148.507 87.718L148.45 88.2147ZM148.784 88.2531L148.293 88.3457L148.509 89.4941L149.001 89.4015L149.492 89.3089L149.276 88.1606L148.784 88.2531ZM149.001 89.4015L148.509 89.4912C148.557 89.7546 148.595 89.9848 148.617 90.1991L149.114 90.1481L149.612 90.0971C149.586 89.8417 149.541 89.5795 149.492 89.3118L149.001 89.4015ZM149.114 90.1481L149.057 90.6449L149.071 90.6464L149.128 90.1497L149.185 89.653L149.171 89.6514L149.114 90.1481ZM149.128 90.1497L149.61 90.2845C149.665 90.0881 149.742 89.8828 149.844 89.6343L149.381 89.4452L148.918 89.256C148.813 89.5131 148.718 89.7615 148.647 90.0149L149.128 90.1497ZM149.381 89.4452L149.843 89.6362L150.286 88.5636L149.824 88.3726L149.362 88.1815L148.919 89.2541L149.381 89.4452ZM149.824 88.3726L149.767 88.8693L150.166 88.9151L150.223 88.4183L150.28 87.9216L149.881 87.8758L149.824 88.3726ZM150.223 88.4183L149.768 88.2105L148.795 90.3412L149.249 90.549L149.704 90.7568L150.678 88.6261L150.223 88.4183ZM149.249 90.549L149.307 90.0522L148.94 90.0101L148.883 90.5069L148.826 91.0036L149.192 91.0457L149.249 90.549ZM148.883 90.5069L149.374 90.4116L149.161 89.3147L148.67 89.41L148.179 89.5053L148.392 90.6022L148.883 90.5069ZM148.67 89.41L149.161 89.3152C149.113 89.0656 149.077 88.8563 149.054 88.6122L148.557 88.6588L148.059 88.7053C148.086 88.9962 148.128 89.2416 148.179 89.5047L148.67 89.41ZM148.557 88.6588L148.614 88.162L148.604 88.161L148.547 88.6577L148.49 89.1545L148.5 89.1555L148.557 88.6588ZM148.547 88.6577L148.073 88.5012C147.995 88.7364 147.908 88.9432 147.808 89.1565L148.262 89.3677L148.715 89.5789C148.825 89.3428 148.929 89.098 149.022 88.8142L148.547 88.6577ZM148.262 89.3677L147.81 89.1542L147.331 90.1671L147.783 90.3806L148.235 90.5942L148.714 89.5813L148.262 89.3677ZM147.783 90.3806L147.84 89.8839L147.474 89.8418L147.417 90.3385L147.36 90.8352L147.726 90.8773L147.783 90.3806ZM147.417 90.3385L147.909 90.2494L147.494 87.9593L147.002 88.0485L146.51 88.1376L146.925 90.4276L147.417 90.3385ZM150.429 88.442L150.486 87.9453L149.817 87.8685L149.937 88.5312L150.429 88.442ZM150.837 88.4889L151.332 88.4166L151.276 88.036L150.894 87.9921L150.837 88.4889ZM151.006 89.6457L150.511 89.718L150.513 89.7261L151.006 89.6457ZM151.09 90.3749L150.591 90.4164L150.625 90.8249L151.033 90.8716L151.09 90.3749ZM151.103 90.3765L151.046 90.8732L151.454 90.92L151.579 90.5298L151.103 90.3765ZM151.381 89.6934L151.836 89.902L151.836 89.9013L151.381 89.6934ZM151.877 88.6083L151.934 88.1116L151.574 88.0701L151.423 88.4004L151.877 88.6083ZM152.212 88.6467L152.703 88.5541L152.635 88.192L152.269 88.15L152.212 88.6467ZM152.428 89.7951L152.92 89.7054L152.92 89.7025L152.428 89.7951ZM152.542 90.5417L152.045 90.5927L152.086 90.9926L152.485 91.0384L152.542 90.5417ZM152.556 90.5433L152.499 91.04L152.922 91.0886L153.037 90.6781L152.556 90.5433ZM152.809 89.8387L152.347 89.6477L152.346 89.6496L152.809 89.8387ZM153.252 88.7661L153.309 88.2694L152.934 88.2264L152.79 88.5751L153.252 88.7661ZM153.651 88.8119L154.106 89.0197L154.392 88.3937L153.708 88.3152L153.651 88.8119ZM152.677 90.9425L152.62 91.4393L152.981 91.4807L153.132 91.1503L152.677 90.9425ZM152.311 90.9004L151.82 90.9957L151.89 91.3554L152.254 91.3972L152.311 90.9004ZM152.098 89.8035L151.607 89.8983L151.607 89.8988L152.098 89.8035ZM151.984 89.0523L152.482 89.0058L152.444 88.6019L152.041 88.5556L151.984 89.0523ZM151.975 89.0513L152.032 88.5546L151.628 88.5081L151.5 88.8948L151.975 89.0513ZM151.689 89.7613L152.141 89.9748L152.143 89.9725L151.689 89.7613ZM151.211 90.7742L151.154 91.2709L151.51 91.3118L151.663 90.9877L151.211 90.7742ZM150.844 90.7321L150.352 90.8212L150.419 91.1865L150.787 91.2288L150.844 90.7321ZM150.429 88.442L150.372 88.9388L150.78 88.9856L150.837 88.4889L150.894 87.9921L150.486 87.9453L150.429 88.442ZM150.837 88.4889L150.343 88.5611L150.511 89.718L151.006 89.6457L151.501 89.5735L151.332 88.4166L150.837 88.4889ZM151.006 89.6457L150.513 89.7261C150.55 89.9567 150.572 90.1847 150.591 90.4164L151.09 90.3749L151.588 90.3334C151.568 90.0964 151.544 89.8363 151.5 89.5653L151.006 89.6457ZM151.09 90.3749L151.033 90.8716L151.046 90.8732L151.103 90.3765L151.16 89.8797L151.147 89.8782L151.09 90.3749ZM151.103 90.3765L151.579 90.5298C151.642 90.3363 151.731 90.1294 151.836 89.902L151.381 89.6934L150.927 89.4849C150.821 89.7161 150.709 89.969 150.627 90.2231L151.103 90.3765ZM151.381 89.6934L151.836 89.9013L152.332 88.8162L151.877 88.6083L151.423 88.4004L150.927 89.4856L151.381 89.6934ZM151.877 88.6083L151.82 89.105L152.155 89.1434L152.212 88.6467L152.269 88.15L151.934 88.1116L151.877 88.6083ZM152.212 88.6467L151.721 88.7393L151.937 89.8876L152.428 89.7951L152.92 89.7025L152.703 88.5541L152.212 88.6467ZM152.428 89.7951L151.936 89.8848C151.984 90.1482 152.023 90.3783 152.045 90.5927L152.542 90.5417L153.04 90.4907C153.013 90.2352 152.969 89.973 152.92 89.7054L152.428 89.7951ZM152.542 90.5417L152.485 91.0384L152.499 91.04L152.556 90.5433L152.613 90.0465L152.599 90.045L152.542 90.5417ZM152.556 90.5433L153.037 90.6781C153.092 90.4817 153.17 90.2763 153.271 90.0279L152.809 89.8387L152.346 89.6496C152.241 89.9067 152.145 90.155 152.074 90.4085L152.556 90.5433ZM152.809 89.8387L153.271 90.0298L153.714 88.9572L153.252 88.7661L152.79 88.5751L152.347 89.6477L152.809 89.8387ZM153.252 88.7661L153.195 89.2629L153.594 89.3087L153.651 88.8119L153.708 88.3152L153.309 88.2694L153.252 88.7661ZM153.651 88.8119L153.196 88.6041L152.222 90.7347L152.677 90.9425L153.132 91.1503L154.106 89.0197L153.651 88.8119ZM152.677 90.9425L152.734 90.4458L152.368 90.4037L152.311 90.9004L152.254 91.3972L152.62 91.4393L152.677 90.9425ZM152.311 90.9004L152.801 90.8051L152.589 89.7082L152.098 89.8035L151.607 89.8988L151.82 90.9957L152.311 90.9004ZM152.098 89.8035L152.589 89.7088C152.54 89.4591 152.505 89.2499 152.482 89.0058L151.984 89.0523L151.486 89.0989C151.514 89.3898 151.556 89.6352 151.607 89.8983L152.098 89.8035ZM151.984 89.0523L152.041 88.5556L152.032 88.5546L151.975 89.0513L151.918 89.548L151.927 89.5491L151.984 89.0523ZM151.975 89.0513L151.5 88.8948C151.423 89.1299 151.336 89.3367 151.236 89.5501L151.689 89.7613L152.143 89.9725C152.253 89.7364 152.356 89.4916 152.45 89.2078L151.975 89.0513ZM151.689 89.7613L151.237 89.5477L150.759 90.5606L151.211 90.7742L151.663 90.9877L152.141 89.9748L151.689 89.7613ZM151.211 90.7742L151.268 90.2774L150.901 90.2353L150.844 90.7321L150.787 91.2288L151.154 91.2709L151.211 90.7742ZM150.844 90.7321L151.336 90.6429L150.921 88.3529L150.429 88.442L149.937 88.5312L150.352 90.8212L150.844 90.7321Z"
				fill="#0C0D0E"
			/>
			<path
				d="M120.759 42.0382L92.305 24.4575L128.443 2.54883L143.11 42.1227L120.759 42.0382Z"
				fill="#F1F3F3"
			/>
			<path
				d="M128.247 3.11818L142.56 41.735L120.871 41.6543L93.043 24.458L128.247 3.11818ZM128.643 1.98047L91.5709 24.4541L120.652 42.4269L143.667 42.5114L128.646 1.98047H128.643Z"
				fill="#0C0D0E"
			/>
			<path
				d="M128.028 22.0508L139.124 38.8512"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M125.637 24.9611H93.312C91.7015 24.9611 90.4369 23.6581 90.4869 22.0515L91.0519 3.90962C91.1019 2.30299 92.4471 1 94.0615 1H126.386C127.997 1 129.261 2.30299 129.211 3.90962L128.646 22.0515C128.596 23.6581 127.251 24.9611 125.637 24.9611Z"
				fill="white"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M118.219 19.9222H99.2466L99.6771 6.03906H118.649L118.219 19.9222Z"
				fill="#F1F3F3"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M99.3696 19.5162L104.754 12.2979L108.141 14.9653L113.814 8.04297L118.219 19.9236"
				fill="#F1F3F3"
			/>
			<path
				d="M99.3696 19.5162L104.754 12.2979L108.141 14.9653L113.814 8.04297L118.219 19.9236"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M103.97 9.93319C103.744 9.93319 103.532 9.84479 103.378 9.6872C103.225 9.52961 103.144 9.31821 103.152 9.09528C103.167 8.61867 103.567 8.23047 104.047 8.23047C104.274 8.23047 104.485 8.31887 104.639 8.47646C104.793 8.63405 104.874 8.84545 104.866 9.06838C104.85 9.54499 104.451 9.93319 103.97 9.93319Z"
				fill="#F1F3F3"
			/>
			<path
				d="M104.047 8.61443C104.17 8.61443 104.282 8.66055 104.362 8.74511C104.443 8.82967 104.485 8.94113 104.482 9.06029C104.474 9.3255 104.239 9.55227 103.97 9.55227C103.847 9.55227 103.736 9.50615 103.655 9.42159C103.574 9.34087 103.532 9.22556 103.536 9.10641C103.544 8.8412 103.778 8.61443 104.047 8.61443ZM104.047 7.8457C103.363 7.8457 102.79 8.39918 102.767 9.08335C102.744 9.76751 103.282 10.321 103.97 10.321C104.658 10.321 105.227 9.76751 105.25 9.08335C105.273 8.39918 104.735 7.8457 104.047 7.8457Z"
				fill="#0C0D0E"
			/>
			<path
				d="M48.9566 133.356L48.4454 35.8164H196.217L197.163 133.356H48.9566Z"
				fill="white"
			/>
			<path
				d="M195.837 36.2004L196.771 132.971H49.3332L48.8258 36.2004H195.833M196.598 35.4316H48.0571L48.5721 133.74H197.547L196.598 35.4316Z"
				fill="#0C0D0E"
			/>
			<path
				d="M48.3184 42.7541L48.3991 35.8164H195.987L195.91 42.7541H48.3184Z"
				fill="#0C0D0E"
			/>
			<path
				d="M195.598 36.2004L195.529 42.3694H48.7066L48.7758 36.2004H195.598ZM196.375 35.4316H48.0147L47.9302 43.1381H196.29L196.375 35.4316Z"
				fill="#0C0D0E"
			/>
			<path
				d="M53.7803 40.3012C53.6073 40.3012 53.442 40.2282 53.3152 40.1013C53.1615 39.9437 53.0769 39.717 53.0808 39.4825C53.0884 39.0213 53.4228 38.6484 53.8226 38.6484C53.9955 38.6484 54.1608 38.7215 54.2877 38.8483C54.4414 39.0059 54.526 39.2327 54.5221 39.4671C54.5144 39.9284 54.18 40.3012 53.7803 40.3012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M53.8225 39.0285C53.8917 39.0285 53.9571 39.0592 54.0147 39.113C54.0954 39.1976 54.1416 39.3206 54.1377 39.459C54.1339 39.7011 53.9648 39.9164 53.7803 39.9164C53.7111 39.9164 53.6457 39.8856 53.5881 39.8318C53.5074 39.7472 53.4612 39.6242 53.4651 39.4897C53.4689 39.2476 53.6381 39.0323 53.8225 39.0323M53.8225 38.2598C53.2114 38.2598 52.7079 38.8017 52.6964 39.4705C52.6848 40.1393 53.1691 40.6812 53.7803 40.6812C54.3914 40.6812 54.8949 40.1393 54.9065 39.4705C54.918 38.8017 54.4337 38.2598 53.8225 38.2598Z"
				fill="#F1F3F3"
			/>
			<path
				d="M58.9422 40.3012C58.7692 40.3012 58.6039 40.2282 58.4771 40.1013C58.3233 39.9437 58.2388 39.717 58.2426 39.4825C58.2503 39.0213 58.5847 38.6484 58.9844 38.6484C59.1574 38.6484 59.3227 38.7215 59.4495 38.8483C59.6033 39.0059 59.6878 39.2327 59.684 39.4671C59.6763 39.9284 59.3419 40.3012 58.9422 40.3012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M58.9844 39.0285C59.0536 39.0285 59.1189 39.0592 59.1766 39.113C59.2573 39.1976 59.3034 39.3206 59.2996 39.459C59.2957 39.7011 59.1266 39.9164 58.9421 39.9164C58.873 39.9164 58.8076 39.8856 58.75 39.8318C58.6692 39.7472 58.6231 39.6242 58.627 39.4897C58.6308 39.2476 58.7999 39.0323 58.9844 39.0323M58.9844 38.2598C58.3733 38.2598 57.8698 38.8017 57.8582 39.4705C57.8467 40.1393 58.331 40.6812 58.9421 40.6812C59.5533 40.6812 60.0568 40.1393 60.0683 39.4705C60.0798 38.8017 59.5955 38.2598 58.9844 38.2598Z"
				fill="#F1F3F3"
			/>
			<path
				d="M64.1005 40.3012C63.9275 40.3012 63.7623 40.2282 63.6354 40.1013C63.4817 39.9437 63.3971 39.717 63.4009 39.4825C63.4086 39.0213 63.743 38.6484 64.1428 38.6484C64.3157 38.6484 64.481 38.7215 64.6078 38.8483C64.7616 39.0059 64.8461 39.2288 64.8423 39.4671C64.8346 39.9284 64.5002 40.3012 64.1005 40.3012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M64.1427 39.0285C64.2119 39.0285 64.2773 39.0592 64.3349 39.113C64.4156 39.1976 64.4618 39.3206 64.4579 39.459C64.4541 39.7011 64.285 39.9164 64.1005 39.9164C64.0313 39.9164 63.9659 39.8856 63.9083 39.8318C63.8276 39.7472 63.7814 39.6242 63.7853 39.4897C63.7891 39.2476 63.9582 39.0323 64.1427 39.0323M64.1427 38.2598C63.5316 38.2598 63.0281 38.8017 63.0166 39.4705C63.005 40.1393 63.4893 40.6812 64.1005 40.6812C64.7116 40.6812 65.2151 40.1393 65.2266 39.4705C65.2382 38.8017 64.7539 38.2598 64.1427 38.2598Z"
				fill="#F1F3F3"
			/>
			<path
				d="M54.4068 86.4325V50.8828H123.192V86.9091L54.4068 86.4325Z"
				fill="white"
			/>
			<path
				d="M172.717 46.8585C171.876 46.8585 171.188 46.159 171.188 45.2941L171.172 33.0676C171.172 32.1989 171.86 31.484 172.714 31.4802L194.046 31.3418C194.899 31.3418 195.587 32.0413 195.587 32.9062L195.602 45.1327C195.602 46.0014 194.914 46.7163 194.061 46.7201L172.721 46.8585H172.717Z"
				fill="#F1F3F3"
			/>
			<path
				d="M194.049 30.957V31.7258C194.68 31.7258 195.195 32.2562 195.195 32.9057L195.214 45.1323C195.214 45.7896 194.695 46.3315 194.057 46.3354L172.717 46.4737C172.087 46.4737 171.572 45.9433 171.572 45.2937L171.557 33.0672C171.557 32.4099 172.075 31.868 172.713 31.8641L194.046 31.7258L194.053 30.957M194.049 30.957C194.049 30.957 194.042 30.957 194.038 30.957L172.706 31.0954C171.641 31.1031 170.78 31.9871 170.784 33.0672L170.799 45.2937C170.799 46.3738 171.656 47.2425 172.713 47.2425C172.717 47.2425 172.721 47.2425 172.725 47.2425L194.057 47.1041C195.122 47.0964 195.983 46.2124 195.979 45.1323L195.96 32.9057C195.96 31.8257 195.103 30.957 194.046 30.957H194.049Z"
				fill="#0C0D0E"
			/>
			<path
				d="M176.2 44.2489C175.239 44.2489 174.459 43.4494 174.455 42.4693L174.435 28.8821C174.435 27.8905 175.22 27.0833 176.188 27.0756L199.888 26.9219C200.86 26.9219 201.641 27.7213 201.644 28.7015L201.664 42.2887C201.664 43.2803 200.88 44.0875 199.911 44.0952L176.2 44.2489Z"
				fill="#F1F3F3"
			/>
			<path
				d="M199.903 26.5371V27.3058C200.653 27.3058 201.26 27.9323 201.264 28.7011L201.283 42.2883C201.283 43.0685 200.668 43.7066 199.911 43.7104L176.2 43.8641C175.45 43.8641 174.843 43.2376 174.839 42.4689L174.82 28.8817C174.82 28.1015 175.435 27.4634 176.192 27.4596L199.892 27.3058L199.899 26.5371M199.903 26.5371C199.903 26.5371 199.896 26.5371 199.888 26.5371L176.188 26.6909C175.008 26.6985 174.051 27.6787 174.051 28.8817L174.07 42.4689C174.07 43.6681 175.023 44.6329 176.2 44.6329C176.203 44.6329 176.207 44.6329 176.215 44.6329L199.915 44.4791C201.095 44.4714 202.052 43.4913 202.052 42.2883L202.033 28.7011C202.033 27.5019 201.079 26.5371 199.903 26.5371Z"
				fill="#0C0D0E"
			/>
			<path
				d="M180.07 41.4193C178.979 41.4193 178.091 40.5122 178.091 39.3975L178.068 24.3036C178.068 23.1813 178.959 22.2627 180.059 22.255L206.391 22.082C207.494 22.082 208.382 22.9891 208.386 24.1038L208.409 39.1977C208.409 40.32 207.518 41.2386 206.418 41.2463L180.07 41.4193Z"
				fill="#F1F3F3"
			/>
			<path
				d="M206.407 21.6973V22.466C207.287 22.466 208.002 23.2001 208.002 24.1034L208.025 39.1973C208.025 40.1082 207.306 40.8577 206.414 40.8616L180.07 41.0345C179.19 41.0345 178.475 40.3004 178.475 39.3972L178.452 24.3033C178.452 23.3923 179.175 22.6428 180.063 22.639L206.399 22.466L206.411 21.6973M206.407 21.6973C206.407 21.6973 206.395 21.6973 206.391 21.6973L180.059 21.8702C178.748 21.8779 177.683 22.9695 177.687 24.3071L177.71 39.401C177.71 40.7309 178.771 41.8033 180.074 41.8033C180.078 41.8033 180.086 41.8033 180.089 41.8033L206.422 41.6303C207.733 41.6226 208.797 40.531 208.794 39.1934L208.771 24.0995C208.771 22.7696 207.71 21.6934 206.407 21.6973Z"
				fill="#0C0D0E"
			/>
			<path
				d="M213.648 38.5395L184.387 38.7278C182.93 38.7355 181.746 37.5402 181.742 36.0565L181.719 19.283C181.719 17.7993 182.899 16.5886 184.356 16.577L213.617 16.3887C215.074 16.381 216.258 17.5764 216.262 19.06L216.285 35.8336C216.285 37.3172 215.105 38.528 213.648 38.5395Z"
				fill="#F1F3F3"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M193.98 26.6454L204.312 26.5762"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M193.984 28.7235L204.316 28.6543"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M199.115 24.041L199.657 24.7944L198.604 24.8021L199.115 24.041Z"
				fill="#F1F3F3"
			/>
			<path
				d="M199.104 23.3691L197.881 25.191L200.407 25.1756L199.104 23.3691Z"
				fill="#0C0D0E"
			/>
			<path
				d="M198.639 30.5038L199.692 30.4961L199.181 31.2571L198.639 30.5038Z"
				fill="#F1F3F3"
			/>
			<path
				d="M200.414 30.1074L197.889 30.1228L199.192 31.9293L200.414 30.1074Z"
				fill="#0C0D0E"
			/>
			<path
				d="M178.225 85.0977H207.21C208.44 85.0977 209.435 86.097 209.435 87.3231V103.578C209.435 104.808 208.436 105.803 207.21 105.803H178.225C176.995 105.803 176 104.804 176 103.578V87.3231C176 86.0932 176.999 85.0977 178.225 85.0977Z"
				fill="#F1F3F3"
			/>
			<path
				d="M207.21 85.4836C208.225 85.4836 209.051 86.3099 209.051 87.3247V103.579C209.051 104.594 208.225 105.42 207.21 105.42H178.225C177.21 105.42 176.384 104.594 176.384 103.579V87.3247C176.384 86.3099 177.21 85.4836 178.225 85.4836H207.21ZM207.21 84.7148H178.225C176.784 84.7148 175.615 85.8833 175.615 87.3247V103.579C175.615 105.021 176.784 106.189 178.225 106.189H207.21C208.651 106.189 209.82 105.021 209.82 103.579V87.3247C209.82 85.8833 208.651 84.7148 207.21 84.7148Z"
				fill="#0C0D0E"
			/>
			<path
				d="M188.342 90.7012H186.201V92.8305H188.342V90.7012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M187.957 91.0871V92.4516H186.585V91.0871H187.957ZM188.726 90.3184H185.816V93.2203H188.726V90.3184Z"
				fill="#0C0D0E"
			/>
			<path
				d="M187.911 98.0703H186.201V100.204H187.911V98.0703Z"
				fill="#F1F3F3"
			/>
			<path
				d="M187.527 98.4562V99.8207H186.585V98.4562H187.527ZM188.295 97.6875H185.816V100.589H188.295V97.6875Z"
				fill="#0C0D0E"
			/>
			<path
				d="M190.39 94.3867H186.201V96.5199H190.39V94.3867Z"
				fill="#F1F3F3"
			/>
			<path
				d="M190.006 94.7687V96.1332H186.585V94.7687H190.006ZM190.775 94H185.816V96.9019H190.775V94Z"
				fill="#0C0D0E"
			/>
			<path
				d="M194.088 94.3867H192.074V96.5199H194.088V94.3867Z"
				fill="#F1F3F3"
			/>
			<path
				d="M193.703 94.7687V96.1332H192.458V94.7687H193.703ZM194.472 94H191.689V96.9019H194.472V94Z"
				fill="#0C0D0E"
			/>
			<path
				d="M197.951 94.3867H195.937V96.5199H197.951V94.3867Z"
				fill="#F1F3F3"
			/>
			<path
				d="M197.566 94.7687V96.1332H196.321V94.7687H197.566ZM198.335 94H195.552V96.9019H198.335V94Z"
				fill="#0C0D0E"
			/>
			<path
				d="M198.012 90.7012H195.871V92.8305H198.012V90.7012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M197.628 91.0871V92.4516H196.256V91.0871H197.628ZM198.396 90.3184H195.487V93.2203H198.396V90.3184Z"
				fill="#0C0D0E"
			/>
			<path
				d="M198.012 98.0703H194.857V100.204H198.012V98.0703Z"
				fill="#F1F3F3"
			/>
			<path
				d="M197.628 98.4562V99.8207H195.241V98.4562H197.628ZM198.396 97.6875H194.472V100.589H198.396V97.6875Z"
				fill="#0C0D0E"
			/>
			<path
				d="M193.127 98.0703H189.541V100.204H193.127V98.0703Z"
				fill="#F1F3F3"
			/>
			<path
				d="M192.742 98.4562V99.8207H189.925V98.4562H192.742ZM193.511 97.6875H189.156V100.589H193.511V97.6875Z"
				fill="#0C0D0E"
			/>
			<path
				d="M194.088 90.7012H190.021V92.8305H194.088V90.7012Z"
				fill="#F1F3F3"
			/>
			<path
				d="M193.703 91.0871V92.4516H190.409V91.0871H193.703ZM194.472 90.3184H189.641V93.2203H194.472V90.3184Z"
				fill="#0C0D0E"
			/>
			<path
				d="M199.961 90.7715H184.498V101.072H199.961V90.7715Z"
				fill="#F1F3F3"
			/>
			<path
				d="M199.576 91.1574V100.69H184.882V91.1574H199.576ZM200.345 90.3887H184.114V101.458H200.345V90.3887Z"
				fill="#0C0D0E"
			/>
			<path
				d="M227.224 135.377C227.02 126.39 226.405 125.779 217.588 125.779C226.405 125.779 226.993 125.168 226.793 116.182C226.997 125.168 227.612 125.779 236.429 125.779C227.612 125.779 227.024 126.39 227.224 135.377Z"
				fill="#0C0D0E"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M222.703 76.4688H178.756C176.569 76.4688 174.797 78.2412 174.797 80.4277V105.073C174.797 107.259 176.569 109.032 178.756 109.032H222.703C224.89 109.032 226.662 107.259 226.662 105.073V80.4277C226.662 78.2412 224.89 76.4688 222.703 76.4688Z"
				fill="white"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M194.295 85.3477H190.651V88.976H194.295V85.3477Z"
				fill="#F1F3F3"
			/>
			<path
				d="M193.911 85.7316V88.5913H191.036V85.7316H193.911ZM194.68 84.9629H190.267V89.36H194.68V84.9629Z"
				fill="#0C0D0E"
			/>
			<path
				d="M193.642 96.5215H190.651V100.15H193.642V96.5215Z"
				fill="#F1F3F3"
			/>
			<path
				d="M193.258 96.9054V99.7651H191.036V96.9054H193.258ZM194.026 96.1367H190.267V100.534H194.026V96.1367Z"
				fill="#0C0D0E"
			/>
			<path
				d="M197.401 90.9355H190.651V94.5639H197.401V90.9355Z"
				fill="#F1F3F3"
			/>
			<path
				d="M197.017 91.3215V94.1811H191.036V91.3215H197.017ZM197.785 90.5527H190.267V94.9498H197.785V90.5527Z"
				fill="#0C0D0E"
			/>
			<path
				d="M203.005 90.9355H199.557V94.5639H203.005V90.9355Z"
				fill="#F1F3F3"
			/>
			<path
				d="M202.621 91.3215V94.1811H199.942V91.3215H202.621ZM203.389 90.5527H199.173V94.9498H203.389V90.5527Z"
				fill="#0C0D0E"
			/>
			<path
				d="M208.859 90.9355H205.411V94.5639H208.859V90.9355Z"
				fill="#F1F3F3"
			/>
			<path
				d="M208.474 91.3215V94.1811H205.795V91.3215H208.474ZM209.243 90.5527H205.027V94.9498H209.243V90.5527Z"
				fill="#0C0D0E"
			/>
			<path
				d="M208.959 85.3477H205.315V88.976H208.959V85.3477Z"
				fill="#F1F3F3"
			/>
			<path
				d="M208.574 85.7316V88.5913H205.699V85.7316H208.574ZM209.343 84.9629H204.931V89.36H209.343V84.9629Z"
				fill="#0C0D0E"
			/>
			<path
				d="M208.959 96.5215H203.774V100.15H208.959V96.5215Z"
				fill="#F1F3F3"
			/>
			<path
				d="M208.574 96.9054V99.7651H204.158V96.9054H208.574ZM209.343 96.1367H203.389V100.534H209.343V96.1367Z"
				fill="#0C0D0E"
			/>
			<path
				d="M201.548 96.5215H195.714V100.15H201.548V96.5215Z"
				fill="#F1F3F3"
			/>
			<path
				d="M201.164 96.9054V99.7651H196.098V96.9054H201.164ZM201.933 96.1367H195.329V100.534H201.933V96.1367Z"
				fill="#0C0D0E"
			/>
			<path
				d="M203.005 85.3477H196.444V88.976H203.005V85.3477Z"
				fill="#F1F3F3"
			/>
			<path
				d="M202.62 85.7316V88.5913H196.828V85.7316H202.62ZM203.389 84.9629H196.059V89.36H203.389V84.9629Z"
				fill="#0C0D0E"
			/>
			<path
				d="M58.5657 141.433H26.064C24.4459 141.433 23.2044 140.011 23.2928 138.263L24.2921 118.468C24.3805 116.715 25.7642 115.297 27.3862 115.297H59.8879C61.5061 115.297 62.7475 116.719 62.6591 118.468L61.6598 138.263C61.5714 140.015 60.1877 141.433 58.5657 141.433Z"
				fill="white"
				stroke="#0C0D0E"
				strokeMiterlimit="10"
			/>
			<path
				d="M49.2026 122.051L49.0603 124.849C49.0603 124.849 49.0065 123.68 47.077 123.68H44.1943L43.6754 133.931C43.6754 133.931 44.2366 134.542 44.7862 134.658C43.5102 134.658 42.9259 134.669 42.7107 134.673C42.7107 134.673 42.6991 134.673 42.6684 134.673C42.6261 134.673 42.6069 134.673 42.6069 134.673C42.3917 134.665 41.8074 134.654 40.5313 134.654C41.0925 134.539 41.7152 133.928 41.7152 133.928L42.2341 123.677H39.3514C37.4219 123.677 37.2489 124.845 37.2489 124.845L37.3911 122.047H49.2064L49.2026 122.051Z"
				fill="#CDCFD4"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M83.9595 143.19C83.456 142.763 83.0444 142.239 82.7496 141.649C82.4548 141.059 82.2831 140.414 82.2448 139.756C82.2065 139.097 82.3024 138.438 82.5268 137.817C82.7511 137.197 83.0992 136.628 83.5499 136.146L113.544 104.07L117.731 107.609L91.0256 142.439C90.625 142.971 90.1192 143.416 89.5394 143.745C88.9597 144.074 88.3186 144.28 87.6558 144.35C86.993 144.421 86.3229 144.354 85.687 144.154C85.0511 143.955 84.4631 143.626 83.9595 143.19Z"
				fill="white"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M132.42 113.503C147.005 113.503 158.829 101.679 158.829 87.0931C158.829 72.5076 147.005 60.6836 132.42 60.6836C117.834 60.6836 106.01 72.5076 106.01 87.0931C106.01 101.679 117.834 113.503 132.42 113.503Z"
				fill="white"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M132.42 108.201C144.077 108.201 153.527 98.7506 153.527 87.0935C153.527 75.4363 144.077 65.9863 132.42 65.9863C120.763 65.9863 111.313 75.4363 111.313 87.0935C111.313 98.7506 120.763 108.201 132.42 108.201Z"
				fill="white"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M46.0741 95.2222L133.933 89.9734L70.3428 37.8652L46.0741 95.2222Z"
				fill="#DEDEFA"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M71.1198 85.5233C84.1377 72.5463 84.1744 51.4768 71.2018 38.4634C58.2292 25.4499 37.1597 25.4204 24.1418 38.3975C11.1239 51.3745 11.0872 72.444 24.0598 85.4575C37.0324 98.4709 58.1019 98.5004 71.1198 85.5233Z"
				fill="#EDEDFC"
				stroke="#0C0D0E"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
			<path
				d="M63.5649 51C64.8973 50.9568 66.0012 52.0283 66.0015 53.3643C66.0015 54.6426 65.2087 55.4612 63.7095 55.7256L56.1802 57.0801C54.8261 57.1237 53.7507 58.2358 53.7505 59.5898L54.5034 78.0986C54.5033 79.2934 53.5371 80.2605 52.3423 80.2607C51.2126 80.2607 50.2741 79.3878 50.187 78.2617L49.5063 69.2441C49.4627 68.6758 48.9878 68.2373 48.4194 68.2373C47.8513 68.2376 47.3772 68.676 47.3335 69.2441L46.6528 78.2617C46.5694 79.3878 45.6273 80.2607 44.4976 80.2607C43.3028 80.2605 42.3366 79.2934 42.3364 78.0986L43.144 58.0361L49.0063 57.6084L39.6919 56.6201L32.8911 55.7217C31.403 55.5514 30.5991 54.6965 30.5991 53.3604C30.5996 52.0246 31.7073 50.9568 33.0396 51L42.0972 52.4229C46.2074 52.8284 50.2636 52.8393 54.2651 52.4229L63.5649 50.9961V51ZM48.3003 43.166C50.5441 43.166 52.3635 44.9857 52.3638 47.2295C52.3638 49.4735 50.5443 51.293 48.3003 51.293C46.0563 51.2929 44.2368 49.4735 44.2368 47.2295C44.2371 44.9858 46.0565 43.1661 48.3003 43.166Z"
				fill="#0C0D0E"
			/>
		</SvgIcon>
	);
};

export default AccessibilityAssistantDashboardIcon;
