<?php

declare (strict_types=1);
namespace Voxel\Vendor\Paddle\SDK\Resources\Transactions\Operations\Price;

use Voxel\Vendor\Paddle\SDK\Entities\Shared\CustomData;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\Money;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\PriceQuantity;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\TaxMode;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\TimePeriod;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\UnitPriceOverride;
use Voxel\Vendor\Paddle\SDK\FiltersUndefined;
use Voxel\Vendor\Paddle\SDK\Undefined;
class TransactionNonCatalogPriceWithProduct implements \JsonSerializable
{
    use FiltersUndefined;
    /**
     * @param array<UnitPriceOverride> $unitPriceOverrides
     */
    public function __construct(public string $description, public Money $unitPrice, public TransactionNonCatalogProduct $product, public string|Undefined|null $name = new Undefined(), public TimePeriod|Undefined|null $billingCycle = new Undefined(), public TimePeriod|Undefined|null $trialPeriod = new Undefined(), public TaxMode|Undefined $taxMode = new Undefined(), public array|Undefined $unitPriceOverrides = new Undefined(), public PriceQuantity|Undefined $quantity = new Undefined(), public CustomData|Undefined|null $customData = new Undefined())
    {
    }
    public function jsonSerialize(): array
    {
        return $this->filterUndefined(['description' => $this->description, 'unit_price' => $this->unitPrice, 'product' => $this->product, 'name' => $this->name, 'billing_cycle' => $this->billingCycle, 'trial_period' => $this->trialPeriod, 'tax_mode' => $this->taxMode, 'unit_price_overrides' => $this->unitPriceOverrides, 'quantity' => $this->quantity, 'custom_data' => $this->customData]);
    }
}
