<?php

namespace Voxel\Modules\Claim_Listings\Controllers\Frontend;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Claim_Order_Controller extends \Voxel\Controllers\Base_Controller {

	protected function hooks() {
		$this->on( 'voxel/product-types/orders/order:updated', '@order_updated' );
		$this->filter( 'voxel/orders/view_order/item/components', '@register_claim_component', 10, 3 );
	}

	protected function order_updated( $order ) {
		if ( in_array( $order->get_status(), [ 'completed', 'sub_active' ], true ) ) {
			foreach ( $order->get_items() as $order_item ) {
				if ( ! ( $order_item->get_type() === 'regular' && $order_item->get_product_field_key() === 'voxel:claim' ) ) {
					continue;
				}

				if ( $order_item->get_details( 'claim.approved' ) ) {
					continue;
				}

				$post = $order_item->get_post();
				$vendor = $order->get_vendor();
				$customer = $order->get_customer();
				if ( ! ( $post && $vendor && $customer ) ) {
					continue;
				}

				if ( $post->get_author_id() === $vendor->get_id() || $vendor->has_cap('administrator') || $vendor->has_cap('editor') ) {
					wp_update_post( [
						'ID' => $post->get_id(),
						'post_author' => $customer->get_id(),
					] );

					$post->set_verified(true);

					delete_user_meta( $customer->get_id(), 'voxel:post_stats' );
					delete_user_meta( $vendor->get_id(), 'voxel:post_stats' );

					$order_item->set_details( 'claim.approved', true );
					$order_item->save();

					( new \Voxel\Events\Claims\Claim_Processed_Event )->dispatch( $order_item->get_id() );
				}
			}
		} else {
			foreach ( $order->get_items() as $order_item ) {
				if ( ! ( $order_item->get_type() === 'regular' && $order_item->get_product_field_key() === 'voxel:claim' ) ) {
					continue;
				}

				if ( ! $order_item->get_details( 'claim.approved' ) ) {
					continue;
				}

				$post = $order_item->get_post();
				$vendor = $order->get_vendor();
				$customer = $order->get_customer();
				if ( ! ( $post && $vendor && $customer ) ) {
					continue;
				}

				if ( $post->get_author_id() === $customer->get_id() ) {
					wp_update_post( [
						'ID' => $post->get_id(),
						'post_author' => $vendor->get_id(),
					] );

					$post->set_verified(false);

					delete_user_meta( $customer->get_id(), 'voxel:post_stats' );
					delete_user_meta( $vendor->get_id(), 'voxel:post_stats' );

					$order_item->set_details( 'claim.approved', false );
					$order_item->save();
				}
			}
		}
	}

	protected function register_claim_component( $components, $order_item, $order ) {
		if ( $order_item->get_product_field_key() !== 'voxel:claim' ) {
			return $components;
		}

		$details = [
			'claim_approved' => !! $order_item->get_details( 'claim.approved' ),
			'l10n' => [
				'proof_of_ownership' => _x( 'Proof of ownership', 'single order', 'voxel' ),
				'claim_successful' => _x( 'The listing has been claimed succesfully', 'single order', 'voxel' ),
				'view_listing' => _x( 'View listing', 'single order', 'voxel' ),
			],
		];

		// proof of ownership
		$proof_of_ownership = [];
		$attachment_ids = explode( ',', $order_item->get_details( 'proof_of_ownership', '' ) );
		foreach ( $attachment_ids as $attachment_id ) {
			if ( $attachment_url = wp_get_attachment_url( $attachment_id ) ) {
				$display_filename = get_post_meta( $attachment_id, '_display_filename', true );
				$proof_of_ownership[] = [
					'name' => ! empty( $display_filename )
						? $display_filename
						: wp_basename( get_attached_file( $attachment_id ) ),
					'url' => $attachment_url,
				];
			}
		}

		$details['proof_of_ownership'] = $proof_of_ownership;

		$src = trailingslashit( get_template_directory_uri() ).'app/modules/claim-listings/assets/scripts/order-item-claim.esm.js';
		$components[] = [
			'type' => 'order-item-claim',
			'src' => add_query_arg( 'v', \Voxel\get_assets_version(), $src ),
			'data' => $details,
		];

		return $components;
	}
}
