<?php

namespace Voxel\Modules\Claim_Listings\Controllers\Frontend;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Claim_Checkout_Controller extends \Voxel\Controllers\Base_Controller {

	protected function hooks() {
		$this->filter( 'voxel/cart_summary/item/components', '@register_cart_item_component', 10, 2 );
		$this->filter( 'voxel/direct_cart/metadata', '@add_direct_cart_meta', 10, 2 );
		$this->on( 'voxel/checkout/before-create-order', '@save_proof_of_ownership' );
	}

	protected function register_cart_item_component( $components, $cart_item ) {
		if ( $cart_item->get_product_field_key() === 'voxel:claim' ) {
			$file_field = \Voxel\Modules\Claim_Listings\get_proof_of_ownership_field();

			$data = [
				'allowed_file_types' => (array) $file_field->get_prop('allowed-types'),
				'max_count' => $file_field->get_prop('max-count'),
				'proof_of_ownership' => [
					'status' => \Voxel\get( 'product_settings.claims.proof_of_ownership', 'optional' ),
					'enabled' => false,
					'files' => [],
				],
				'l10n' => [
					'switcher_label' => _x( 'Add proof of ownership?', 'cart summary', 'voxel' ),
					'file_field_label' => _x( 'Proof of ownership', 'cart summary', 'voxel' ),
					'file_field_tooltip' => _x( 'Upload a business document to verify your ownership', 'cart summary', 'voxel' ),
				],
			];

			$src = trailingslashit( get_template_directory_uri() ).'app/modules/claim-listings/assets/scripts/cart-item-claim.esm.js';
			$components[] = [
				'type' => 'cart-item-claim',
				'src' => add_query_arg( 'v', \Voxel\get_assets_version(), $src ),
				'data' => $data,
			];
		}

		return $components;
	}

	protected function add_direct_cart_meta( $meta, $cart_item ) {
		if ( $cart_item->get_product_field_key() === 'voxel:claim' ) {
			$meta['cart_label'] = _x( 'Claim listing', 'cart summary', 'voxel' );
		}

		return $meta;
	}

	protected function save_proof_of_ownership( $cart ) {
		foreach ( $cart->get_items() as $cart_item ) {
			if ( $cart_item->get_product_field_key() === 'voxel:claim' ) {
				$file_field = \Voxel\Modules\Claim_Listings\get_proof_of_ownership_field();
				$raw_uploaded_files = (array) json_decode( wp_unslash( $_REQUEST['proof_of_ownership'] ?? '' ), true );
				$sanitized_files = $file_field->sanitize( $raw_uploaded_files );

				$proof_of_ownership = \Voxel\get( 'product_settings.claims.proof_of_ownership', 'optional' );
				if ( $proof_of_ownership === 'required' ) {
					if ( empty( $sanitized_files ) ) {
						throw new \Exception( _x( 'Proof of ownership is required', 'claim request', 'voxel' ) );
					}
				}

				$file_field->validate( $sanitized_files );

				if ( ! empty( $sanitized_files ) ) {
					add_action( 'voxel/checkout/after-create-order', function( $order ) use ( $file_field, $sanitized_files ) {
						foreach ( $order->get_items() as $order_item ) {
							if ( $order_item->get_product_field_key() === 'voxel:claim' ) {
								$order_item->set_details( 'proof_of_ownership', $file_field->prepare_for_storage( $sanitized_files ) );
								$order_item->save();
							}
						}
					} );
				}
			}
		}
	}

}
