<?php

namespace Voxel\Controllers\Ecommerce;

use Voxel\Utils\Config_Schema\{Schema, Data_Object};

if ( ! defined('ABSPATH') ) {
	exit;
}

class Ecommerce_Controller extends \Voxel\Controllers\Base_Controller {

	protected function dependencies() {
		new Product_Types\Product_Types_Controller;
		new Payments\Payments_Controller;
	}

	protected function hooks() {
		$this->on( 'admin_menu', '@add_menu_page', 10 );
		$this->on( 'admin_menu', '@add_settings_page', 50 );
		$this->on( 'admin_post_voxel_save_product_types_settings', '@save_settings' );
		$this->on( 'init', '@register_catalog_post_type' );
		$this->on( 'voxel_ajax_backend.orders.delete_order', '@delete_order' );
	}

	protected function add_menu_page() {
		add_menu_page(
			__( 'Ecommerce', 'voxel-backend' ),
			__( 'Ecommerce', 'voxel-backend' ),
			'manage_options',
			'voxel-orders',
			function() {
				if ( ! empty( $_GET['order_id'] ) ) {
					$order = \Voxel\Product_Types\Orders\Order::get( $_GET['order_id'] );
					if ( ! $order ) {
						echo '<div class="wrap">'.__( 'Order not found.', 'voxel-backend' ).'</div>';
						return;
					}

					$payment_method = $order->get_payment_method();
					$customer = $order->get_customer();
					$vendor = $order->get_vendor();
					$order_items = $order->get_items();
					$child_orders = $order->get_child_orders();
					$parent_order = $order->get_parent_order();
					$vendor_fees = $order->get_vendor_fees_summary();
					$billing_interval = $order->get_billing_interval();
					$order_amount = $order->get_total();
					if ( ! is_numeric( $order_amount ) ) {
						$order_amount = $order->get_subtotal();
					}

					require locate_template( 'templates/backend/orders/edit-order.php' );
				} else {
					$table = new \Voxel\Product_Types\Order_List_Table;
					$table->prepare_items();
					require locate_template( 'templates/backend/orders/view-orders.php' );
				}
			},
			sprintf( 'data:image/svg+xml;base64,%s', base64_encode( \Voxel\paint_svg(
				file_get_contents( locate_template( 'assets/images/svgs/shopping-bag.svg' ) ),
				'#a7aaad'
			) ) ),
			'0.300'
		);
	}

	protected function add_settings_page() {
		add_submenu_page(
			'voxel-orders',
			__( 'Settings', 'voxel-backend' ),
			__( 'Settings', 'voxel-backend' ),
			'manage_options',
			'voxel-product-types-settings',
			function() {
				$schema = \Voxel\Product_Types\Settings_Schema::get();
				foreach ( (array) \Voxel\get( 'product_settings', [] ) as $group_key => $group_values ) {
					if ( $prop = $schema->get_prop( $group_key ) ) {
						$prop->set_value( $group_values );
					}
				}

				$config = $schema->export();
				$config['tab'] = $_GET['tab'] ?? 'cart_summary';

				$product_types = [];
				foreach ( array_filter( array_merge( \Voxel\Product_Type::get_all(), [
					\Voxel\Product_Type::get('voxel:claim'),
					\Voxel\Product_Type::get_promotions_product_type(),
					\Voxel\Product_Type::get('voxel:membership_plan'),
				] ) ) as $product_type ) {
					$product_types[ $product_type->get_key() ] = [
						'label' => $product_type->get_label(),
						'key' => $product_type->get_key(),
					];
				}

				$props = [
					'claimable_post_types' => array_map( function( $post_type ) {
						return [
							'key' => $post_type->get_key(),
							'label' => $post_type->get_label(),
						];
					}, \Voxel\Post_Type::get_voxel_types() ),
					'product_types' => $product_types,
					'shipping_countries' => \Voxel\Modules\Stripe_Payments\Country_Codes::shipping_supported(),
				];

				require locate_template( 'templates/backend/product-types/settings/settings.php' );
			}
		);
	}

	protected function save_settings() {
		check_admin_referer( 'voxel_save_product_types_settings' );
		if ( ! current_user_can( 'manage_options' ) ) {
			die;
		}

		if ( empty( $_POST['config'] ) ) {
			die;
		}

		$previous_config = \Voxel\get( 'product_settings', [] );
		$submitted_config = json_decode( stripslashes( $_POST['config'] ), true );

		$schema = \Voxel\Product_Types\Settings_Schema::get();
		$schema->set_value( $previous_config );

		foreach ( $submitted_config as $group_key => $group_values ) {
			if ( $prop = $schema->get_prop( $group_key ) ) {
				$prop->set_value( $group_values );
			}
		}

		$config = $schema->export();

		\Voxel\set( 'product_settings', Schema::optimize_for_storage( $config ) );

		wp_safe_redirect( add_query_arg( 'tab', $submitted_config['tab'] ?? null, admin_url( 'admin.php?page=voxel-product-types-settings' ) ) );
		die;
	}

	protected function register_catalog_post_type() {
		register_post_type( '_vx_catalog', [
			'labels' => [
				'name' => 'VX Catalog',
				'singular_name' => 'VX Product',
			],
			'public'              => false,
			'show_ui'             => false, // false
			'show_in_menu'        => false, // false
			'show_in_nav_menus'   => false,
			'capability_type'     => 'page',
			'map_meta_cap'        => true,
			'publicly_queryable'  => false,
			'exclude_from_search' => true,
			'hierarchical'        => false,
			'query_var'           => false,
			'supports' => [''],
			'delete_with_user'    => false,
			'_is_created_by_voxel' => false,
			'has_archive' => false,
			'rewrite' => [
				'slug' => 'vxcatalog',
			],
		] );
	}

	protected function delete_order() {
		if ( ! current_user_can('manage_options') ) {
			wp_safe_redirect( admin_url( 'admin.php?page=voxel-orders' ) );
			exit;
		}

		if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'] ?? '', 'voxel_backend_delete_order' ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=voxel-orders' ) );
			exit;
		}

		$order = \Voxel\Product_Types\Orders\Order::get( $_REQUEST['order_id'] ?? null );
		$order->delete();

		wp_safe_redirect( admin_url( 'admin.php?page=voxel-orders' ) );
		exit;
	}

}
