<?php

namespace Voxel\Modules\Stripe_Payments;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Country_Codes {

	protected static $list;

	protected static $unsupportedShipping = [
		'AS' => true,
		'CX' => true,
		'CC' => true,
		'CU' => true,
		'HM' => true,
		'IR' => true,
		'KP' => true,
		'MH' => true,
		'FM' => true,
		'NF' => true,
		'MP' => true,
		'PW' => true,
		'SD' => true,
		'SY' => true,
		'UM' => true,
		'VI' => true,
	];

	protected static function get_list(): array {
		if ( static::$list === null ) {
			static::$list = [
				'AF' => __( 'Afghanistan', 'voxel-countries' ),
				'AX' => __( 'Aland Islands', 'voxel-countries' ),
				'AL' => __( 'Albania', 'voxel-countries' ),
				'DZ' => __( 'Algeria', 'voxel-countries' ),
				'AS' => __( 'American Samoa', 'voxel-countries' ),
				'AD' => __( 'Andorra', 'voxel-countries' ),
				'AO' => __( 'Angola', 'voxel-countries' ),
				'AI' => __( 'Anguilla', 'voxel-countries' ),
				'AQ' => __( 'Antarctica', 'voxel-countries' ),
				'AG' => __( 'Antigua And Barbuda', 'voxel-countries' ),
				'AR' => __( 'Argentina', 'voxel-countries' ),
				'AM' => __( 'Armenia', 'voxel-countries' ),
				'AW' => __( 'Aruba', 'voxel-countries' ),
				'AU' => __( 'Australia', 'voxel-countries' ),
				'AT' => __( 'Austria', 'voxel-countries' ),
				'AZ' => __( 'Azerbaijan', 'voxel-countries' ),
				'BS' => __( 'Bahamas', 'voxel-countries' ),
				'BH' => __( 'Bahrain', 'voxel-countries' ),
				'BD' => __( 'Bangladesh', 'voxel-countries' ),
				'BB' => __( 'Barbados', 'voxel-countries' ),
				'BY' => __( 'Belarus', 'voxel-countries' ),
				'BE' => __( 'Belgium', 'voxel-countries' ),
				'BZ' => __( 'Belize', 'voxel-countries' ),
				'BJ' => __( 'Benin', 'voxel-countries' ),
				'BM' => __( 'Bermuda', 'voxel-countries' ),
				'BT' => __( 'Bhutan', 'voxel-countries' ),
				'BO' => __( 'Bolivia', 'voxel-countries' ),
				'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'voxel-countries' ),
				'BA' => __( 'Bosnia And Herzegovina', 'voxel-countries' ),
				'BW' => __( 'Botswana', 'voxel-countries' ),
				'BV' => __( 'Bouvet Island', 'voxel-countries' ),
				'BR' => __( 'Brazil', 'voxel-countries' ),
				'IO' => __( 'British Indian Ocean Territory', 'voxel-countries' ),
				'BN' => __( 'Brunei Darussalam', 'voxel-countries' ),
				'BG' => __( 'Bulgaria', 'voxel-countries' ),
				'BF' => __( 'Burkina Faso', 'voxel-countries' ),
				'BI' => __( 'Burundi', 'voxel-countries' ),
				'KH' => __( 'Cambodia', 'voxel-countries' ),
				'CM' => __( 'Cameroon', 'voxel-countries' ),
				'CA' => __( 'Canada', 'voxel-countries' ),
				'CV' => __( 'Cape Verde', 'voxel-countries' ),
				'KY' => __( 'Cayman Islands', 'voxel-countries' ),
				'CF' => __( 'Central African Republic', 'voxel-countries' ),
				'TD' => __( 'Chad', 'voxel-countries' ),
				'CL' => __( 'Chile', 'voxel-countries' ),
				'CN' => __( 'China', 'voxel-countries' ),
				'CX' => __( 'Christmas Island', 'voxel-countries' ),
				'CC' => __( 'Cocos (Keeling) Islands', 'voxel-countries' ),
				'CO' => __( 'Colombia', 'voxel-countries' ),
				'KM' => __( 'Comoros', 'voxel-countries' ),
				'CG' => __( 'Congo', 'voxel-countries' ),
				'CD' => __( 'Congo, Democratic Republic', 'voxel-countries' ),
				'CK' => __( 'Cook Islands', 'voxel-countries' ),
				'CR' => __( 'Costa Rica', 'voxel-countries' ),
				'CI' => __( 'Cote D\'Ivoire', 'voxel-countries' ),
				'HR' => __( 'Croatia', 'voxel-countries' ),
				'CU' => __( 'Cuba', 'voxel-countries' ),
				'CW' => __( 'Curacao', 'voxel-countries' ),
				'CY' => __( 'Cyprus', 'voxel-countries' ),
				'CZ' => __( 'Czech Republic', 'voxel-countries' ),
				'DK' => __( 'Denmark', 'voxel-countries' ),
				'DJ' => __( 'Djibouti', 'voxel-countries' ),
				'DM' => __( 'Dominica', 'voxel-countries' ),
				'DO' => __( 'Dominican Republic', 'voxel-countries' ),
				'EC' => __( 'Ecuador', 'voxel-countries' ),
				'EG' => __( 'Egypt', 'voxel-countries' ),
				'SV' => __( 'El Salvador', 'voxel-countries' ),
				'GQ' => __( 'Equatorial Guinea', 'voxel-countries' ),
				'ER' => __( 'Eritrea', 'voxel-countries' ),
				'EE' => __( 'Estonia', 'voxel-countries' ),
				'ET' => __( 'Ethiopia', 'voxel-countries' ),
				'FK' => __( 'Falkland Islands (Malvinas)', 'voxel-countries' ),
				'FO' => __( 'Faroe Islands', 'voxel-countries' ),
				'FJ' => __( 'Fiji', 'voxel-countries' ),
				'FI' => __( 'Finland', 'voxel-countries' ),
				'FR' => __( 'France', 'voxel-countries' ),
				'GF' => __( 'French Guiana', 'voxel-countries' ),
				'PF' => __( 'French Polynesia', 'voxel-countries' ),
				'TF' => __( 'French Southern Territories', 'voxel-countries' ),
				'GA' => __( 'Gabon', 'voxel-countries' ),
				'GM' => __( 'Gambia', 'voxel-countries' ),
				'GE' => __( 'Georgia', 'voxel-countries' ),
				'DE' => __( 'Germany', 'voxel-countries' ),
				'GH' => __( 'Ghana', 'voxel-countries' ),
				'GI' => __( 'Gibraltar', 'voxel-countries' ),
				'GR' => __( 'Greece', 'voxel-countries' ),
				'GL' => __( 'Greenland', 'voxel-countries' ),
				'GD' => __( 'Grenada', 'voxel-countries' ),
				'GP' => __( 'Guadeloupe', 'voxel-countries' ),
				'GU' => __( 'Guam', 'voxel-countries' ),
				'GT' => __( 'Guatemala', 'voxel-countries' ),
				'GG' => __( 'Guernsey', 'voxel-countries' ),
				'GN' => __( 'Guinea', 'voxel-countries' ),
				'GW' => __( 'Guinea-Bissau', 'voxel-countries' ),
				'GY' => __( 'Guyana', 'voxel-countries' ),
				'HT' => __( 'Haiti', 'voxel-countries' ),
				'HM' => __( 'Heard Island & Mcdonald Islands', 'voxel-countries' ),
				'VA' => __( 'Holy See (Vatican City State)', 'voxel-countries' ),
				'HN' => __( 'Honduras', 'voxel-countries' ),
				'HK' => __( 'Hong Kong', 'voxel-countries' ),
				'HU' => __( 'Hungary', 'voxel-countries' ),
				'IS' => __( 'Iceland', 'voxel-countries' ),
				'IN' => __( 'India', 'voxel-countries' ),
				'ID' => __( 'Indonesia', 'voxel-countries' ),
				'IR' => __( 'Iran, Islamic Republic Of', 'voxel-countries' ),
				'IQ' => __( 'Iraq', 'voxel-countries' ),
				'IE' => __( 'Ireland', 'voxel-countries' ),
				'IM' => __( 'Isle Of Man', 'voxel-countries' ),
				'IL' => __( 'Israel', 'voxel-countries' ),
				'IT' => __( 'Italy', 'voxel-countries' ),
				'JM' => __( 'Jamaica', 'voxel-countries' ),
				'JP' => __( 'Japan', 'voxel-countries' ),
				'JE' => __( 'Jersey', 'voxel-countries' ),
				'JO' => __( 'Jordan', 'voxel-countries' ),
				'KZ' => __( 'Kazakhstan', 'voxel-countries' ),
				'KE' => __( 'Kenya', 'voxel-countries' ),
				'KI' => __( 'Kiribati', 'voxel-countries' ),
				'XK' => __( 'Kosovo', 'voxel-countries' ),
				'KW' => __( 'Kuwait', 'voxel-countries' ),
				'KG' => __( 'Kyrgyzstan', 'voxel-countries' ),
				'LA' => __( 'Lao People\'s Democratic Republic', 'voxel-countries' ),
				'LV' => __( 'Latvia', 'voxel-countries' ),
				'LB' => __( 'Lebanon', 'voxel-countries' ),
				'LS' => __( 'Lesotho', 'voxel-countries' ),
				'LR' => __( 'Liberia', 'voxel-countries' ),
				'LY' => __( 'Libyan Arab Jamahiriya', 'voxel-countries' ),
				'LI' => __( 'Liechtenstein', 'voxel-countries' ),
				'LT' => __( 'Lithuania', 'voxel-countries' ),
				'LU' => __( 'Luxembourg', 'voxel-countries' ),
				'MO' => __( 'Macao', 'voxel-countries' ),
				'MK' => __( 'Macedonia', 'voxel-countries' ),
				'MG' => __( 'Madagascar', 'voxel-countries' ),
				'MW' => __( 'Malawi', 'voxel-countries' ),
				'MY' => __( 'Malaysia', 'voxel-countries' ),
				'MV' => __( 'Maldives', 'voxel-countries' ),
				'ML' => __( 'Mali', 'voxel-countries' ),
				'MT' => __( 'Malta', 'voxel-countries' ),
				'MH' => __( 'Marshall Islands', 'voxel-countries' ),
				'MQ' => __( 'Martinique', 'voxel-countries' ),
				'MR' => __( 'Mauritania', 'voxel-countries' ),
				'MU' => __( 'Mauritius', 'voxel-countries' ),
				'YT' => __( 'Mayotte', 'voxel-countries' ),
				'MX' => __( 'Mexico', 'voxel-countries' ),
				'FM' => __( 'Micronesia, Federated States Of', 'voxel-countries' ),
				'MD' => __( 'Moldova', 'voxel-countries' ),
				'MC' => __( 'Monaco', 'voxel-countries' ),
				'MN' => __( 'Mongolia', 'voxel-countries' ),
				'ME' => __( 'Montenegro', 'voxel-countries' ),
				'MS' => __( 'Montserrat', 'voxel-countries' ),
				'MA' => __( 'Morocco', 'voxel-countries' ),
				'MZ' => __( 'Mozambique', 'voxel-countries' ),
				'MM' => __( 'Myanmar', 'voxel-countries' ),
				'NA' => __( 'Namibia', 'voxel-countries' ),
				'NR' => __( 'Nauru', 'voxel-countries' ),
				'NP' => __( 'Nepal', 'voxel-countries' ),
				'NL' => __( 'Netherlands', 'voxel-countries' ),
				'NC' => __( 'New Caledonia', 'voxel-countries' ),
				'NZ' => __( 'New Zealand', 'voxel-countries' ),
				'NI' => __( 'Nicaragua', 'voxel-countries' ),
				'NE' => __( 'Niger', 'voxel-countries' ),
				'NG' => __( 'Nigeria', 'voxel-countries' ),
				'NU' => __( 'Niue', 'voxel-countries' ),
				'NF' => __( 'Norfolk Island', 'voxel-countries' ),
				'KP' => __( 'North Korea', 'voxel-countries' ),
				'MP' => __( 'Northern Mariana Islands', 'voxel-countries' ),
				'NO' => __( 'Norway', 'voxel-countries' ),
				'OM' => __( 'Oman', 'voxel-countries' ),
				'PK' => __( 'Pakistan', 'voxel-countries' ),
				'PW' => __( 'Palau', 'voxel-countries' ),
				'PS' => __( 'Palestinian Territory, Occupied', 'voxel-countries' ),
				'PA' => __( 'Panama', 'voxel-countries' ),
				'PG' => __( 'Papua New Guinea', 'voxel-countries' ),
				'PY' => __( 'Paraguay', 'voxel-countries' ),
				'PE' => __( 'Peru', 'voxel-countries' ),
				'PH' => __( 'Philippines', 'voxel-countries' ),
				'PN' => __( 'Pitcairn', 'voxel-countries' ),
				'PL' => __( 'Poland', 'voxel-countries' ),
				'PT' => __( 'Portugal', 'voxel-countries' ),
				'PR' => __( 'Puerto Rico', 'voxel-countries' ),
				'QA' => __( 'Qatar', 'voxel-countries' ),
				'RE' => __( 'Reunion', 'voxel-countries' ),
				'RO' => __( 'Romania', 'voxel-countries' ),
				'RU' => __( 'Russian Federation', 'voxel-countries' ),
				'RW' => __( 'Rwanda', 'voxel-countries' ),
				'BL' => __( 'Saint Barthelemy', 'voxel-countries' ),
				'SH' => __( 'Saint Helena', 'voxel-countries' ),
				'KN' => __( 'Saint Kitts And Nevis', 'voxel-countries' ),
				'LC' => __( 'Saint Lucia', 'voxel-countries' ),
				'MF' => __( 'Saint Martin', 'voxel-countries' ),
				'PM' => __( 'Saint Pierre And Miquelon', 'voxel-countries' ),
				'VC' => __( 'Saint Vincent And Grenadines', 'voxel-countries' ),
				'WS' => __( 'Samoa', 'voxel-countries' ),
				'SM' => __( 'San Marino', 'voxel-countries' ),
				'ST' => __( 'Sao Tome And Principe', 'voxel-countries' ),
				'SA' => __( 'Saudi Arabia', 'voxel-countries' ),
				'SN' => __( 'Senegal', 'voxel-countries' ),
				'RS' => __( 'Serbia', 'voxel-countries' ),
				'SC' => __( 'Seychelles', 'voxel-countries' ),
				'SL' => __( 'Sierra Leone', 'voxel-countries' ),
				'SG' => __( 'Singapore', 'voxel-countries' ),
				'SX' => __( 'Sint Maarten', 'voxel-countries' ),
				'SK' => __( 'Slovakia', 'voxel-countries' ),
				'SI' => __( 'Slovenia', 'voxel-countries' ),
				'SB' => __( 'Solomon Islands', 'voxel-countries' ),
				'SO' => __( 'Somalia', 'voxel-countries' ),
				'ZA' => __( 'South Africa', 'voxel-countries' ),
				'GS' => __( 'South Georgia And Sandwich Isl.', 'voxel-countries' ),
				'KR' => __( 'South Korea', 'voxel-countries' ),
				'SS' => __( 'South Sudan', 'voxel-countries' ),
				'ES' => __( 'Spain', 'voxel-countries' ),
				'LK' => __( 'Sri Lanka', 'voxel-countries' ),
				'SD' => __( 'Sudan', 'voxel-countries' ),
				'SR' => __( 'Suriname', 'voxel-countries' ),
				'SJ' => __( 'Svalbard And Jan Mayen', 'voxel-countries' ),
				'SZ' => __( 'Swaziland', 'voxel-countries' ),
				'SE' => __( 'Sweden', 'voxel-countries' ),
				'CH' => __( 'Switzerland', 'voxel-countries' ),
				'SY' => __( 'Syrian Arab Republic', 'voxel-countries' ),
				'TW' => __( 'Taiwan', 'voxel-countries' ),
				'TJ' => __( 'Tajikistan', 'voxel-countries' ),
				'TZ' => __( 'Tanzania', 'voxel-countries' ),
				'TH' => __( 'Thailand', 'voxel-countries' ),
				'TL' => __( 'Timor-Leste', 'voxel-countries' ),
				'TG' => __( 'Togo', 'voxel-countries' ),
				'TK' => __( 'Tokelau', 'voxel-countries' ),
				'TO' => __( 'Tonga', 'voxel-countries' ),
				'TT' => __( 'Trinidad And Tobago', 'voxel-countries' ),
				'TN' => __( 'Tunisia', 'voxel-countries' ),
				'TR' => __( 'Turkey', 'voxel-countries' ),
				'TM' => __( 'Turkmenistan', 'voxel-countries' ),
				'TC' => __( 'Turks And Caicos Islands', 'voxel-countries' ),
				'TV' => __( 'Tuvalu', 'voxel-countries' ),
				'UG' => __( 'Uganda', 'voxel-countries' ),
				'UA' => __( 'Ukraine', 'voxel-countries' ),
				'AE' => __( 'United Arab Emirates', 'voxel-countries' ),
				'GB' => __( 'United Kingdom', 'voxel-countries' ),
				'US' => __( 'United States', 'voxel-countries' ),
				'UM' => __( 'United States Outlying Islands', 'voxel-countries' ),
				'UY' => __( 'Uruguay', 'voxel-countries' ),
				'UZ' => __( 'Uzbekistan', 'voxel-countries' ),
				'VU' => __( 'Vanuatu', 'voxel-countries' ),
				'VE' => __( 'Venezuela', 'voxel-countries' ),
				'VN' => __( 'Viet Nam', 'voxel-countries' ),
				'VG' => __( 'Virgin Islands, British', 'voxel-countries' ),
				'VI' => __( 'Virgin Islands, U.S.', 'voxel-countries' ),
				'WF' => __( 'Wallis And Futuna', 'voxel-countries' ),
				'EH' => __( 'Western Sahara', 'voxel-countries' ),
				'YE' => __( 'Yemen', 'voxel-countries' ),
				'ZM' => __( 'Zambia', 'voxel-countries' ),
				'ZW' => __( 'Zimbabwe', 'voxel-countries' ),
			];
		}

		return static::$list;
	}

	public static function all() {
		return static::get_list();
	}

	public static function shipping_supported() {
		$list = static::get_list();
		foreach ( $list as $code => $country ) {
			if ( isset( static::$unsupportedShipping[ $code ] ) ) {
				unset( $list[ $code ] );
			}
		}

		return $list;
	}

	public static function shipping_unsupported() {
		$list = static::get_list();
		foreach ( $list as $code => $country ) {
			if ( ! isset( static::$unsupportedShipping[ $code ] ) ) {
				unset( $list[ $code ] );
			}
		}

		return $list;
	}
}
