export default {
	template: `<!--minify-->
		<div v-if="data.claim_approved" class="order-event">
			<div class="order-event-icon vx-blue">
				<icon-info/>
			</div>
			<b>{{ data.l10n.claim_successful }}</b>
			<div v-if="orderItem.product.link" class="further-actions">
				<a :href="orderItem.product.link" target="_blank" class="ts-btn ts-btn-1">
					{{ data.l10n.view_listing }}
				</a>
			</div>
		</div>
		<div v-if="data.proof_of_ownership.length" class="order-event">
			<div class="order-event-icon vx-blue">
				<icon-files/>
			</div>
			<span>{{ data.l10n.proof_of_ownership }}</span>
			<ul class="flexify simplify-ul vx-order-files">
				<li v-for="file in data.proof_of_ownership">
					<a :href="file.url" target="_blank" class="ts-order-file">{{ file.name }}</a>
				</li>
			</ul>
		</div>
	`,
	props: {
		orderItem: Object,
		parent: Object,
		order: Object,
		data: Object,
	},
};
