import SvgIcon from '@elementor/ui/SvgIcon';
import { useSettings } from '@ea11y/hooks';

function AccessibilityTextIcon({ size }, props) {
	const { iconDesign } = useSettings();
	const strokeColor = `lch(from ${iconDesign?.color || '#fff'} calc((50 - l) * 100) 0 0)`;
	return (
		<SvgIcon
			viewBox="0 0 94 16"
			fill="none"
			sx={{ fontSize: size * 3 }}
			{...props}
		>
			<path
				d="M5.64 2.57 2.548 12H.055L4.28.625h1.586L5.641 2.57ZM8.21 12l-3.1-9.43L4.86.625h1.6L10.71 12h-2.5Zm-.14-4.234v1.836H2.062V7.766H8.07ZM15.267 10.398c.276 0 .521-.052.735-.156.213-.11.38-.26.5-.453.125-.198.19-.43.195-.695h2.117a2.817 2.817 0 0 1-.477 1.586c-.312.458-.731.82-1.257 1.086-.526.26-1.115.39-1.766.39-.656 0-1.23-.11-1.719-.328a3.354 3.354 0 0 1-1.21-.906 3.973 3.973 0 0 1-.727-1.36 5.619 5.619 0 0 1-.242-1.671v-.227c0-.599.08-1.156.242-1.672.161-.52.404-.974.726-1.36.323-.39.727-.694 1.211-.913.485-.219 1.052-.328 1.703-.328.693 0 1.3.132 1.82.398.527.266.938.646 1.235 1.14.302.49.456 1.071.461 1.743h-2.117a1.762 1.762 0 0 0-.18-.766c-.11-.229-.27-.411-.484-.547-.209-.14-.466-.21-.774-.21-.328 0-.596.07-.804.21-.209.136-.37.323-.485.563a2.802 2.802 0 0 0-.242.805c-.041.296-.062.609-.062.937v.227c0 .328.02.643.062.945.042.302.12.57.235.805.12.234.283.419.492.554.208.136.479.203.812.203ZM23.76 10.398c.277 0 .522-.052.735-.156.214-.11.38-.26.5-.453.125-.198.19-.43.196-.695h2.117a2.817 2.817 0 0 1-.477 1.586c-.312.458-.732.82-1.258 1.086-.526.26-1.114.39-1.765.39-.656 0-1.23-.11-1.719-.328a3.355 3.355 0 0 1-1.21-.906 3.97 3.97 0 0 1-.727-1.36 5.616 5.616 0 0 1-.243-1.671v-.227c0-.599.081-1.156.243-1.672.161-.52.403-.974.726-1.36.323-.39.727-.694 1.211-.913.484-.219 1.052-.328 1.703-.328.693 0 1.3.132 1.82.398.527.266.938.646 1.235 1.14.302.49.456 1.071.46 1.743h-2.116a1.762 1.762 0 0 0-.18-.766c-.11-.229-.27-.411-.484-.547-.209-.14-.467-.21-.774-.21-.328 0-.596.07-.805.21-.208.136-.37.323-.484.563a2.8 2.8 0 0 0-.242.805 6.74 6.74 0 0 0-.063.937v.227c0 .328.021.643.063.945.041.302.12.57.234.805.12.234.284.419.492.554.209.136.48.203.813.203ZM32.653 12.156c-.656 0-1.245-.104-1.765-.312a3.878 3.878 0 0 1-1.329-.883 3.923 3.923 0 0 1-.828-1.305 4.391 4.391 0 0 1-.289-1.594V7.75c0-.64.091-1.227.274-1.758.182-.531.442-.992.78-1.383.345-.39.761-.69 1.25-.898.49-.214 1.043-.32 1.657-.32.6 0 1.13.099 1.594.296.463.198.851.48 1.164.844.318.365.557.802.719 1.313.161.505.242 1.067.242 1.687v.938h-6.719v-1.5h4.508v-.172a1.95 1.95 0 0 0-.172-.836 1.327 1.327 0 0 0-.5-.594c-.224-.146-.51-.219-.86-.219-.296 0-.551.066-.765.196a1.51 1.51 0 0 0-.523.547c-.13.234-.23.51-.297.828A5.268 5.268 0 0 0 30.7 7.75v.313a3 3 0 0 0 .14.937c.1.286.238.534.415.742.182.209.4.37.656.485.26.114.555.171.883.171a2.74 2.74 0 0 0 1.133-.234c.354-.161.658-.404.914-.726l1.093 1.187c-.177.255-.419.5-.726.734a3.88 3.88 0 0 1-1.094.579 4.512 4.512 0 0 1-1.46.218ZM42.123 9.664a.73.73 0 0 0-.14-.437c-.094-.13-.268-.25-.524-.36-.25-.114-.612-.219-1.086-.312a8.473 8.473 0 0 1-1.195-.352 4.145 4.145 0 0 1-.953-.523 2.276 2.276 0 0 1-.625-.72 2 2 0 0 1-.227-.96c0-.354.076-.688.227-1 .156-.313.378-.589.664-.828a3.142 3.142 0 0 1 1.063-.57c.421-.141.895-.211 1.421-.211.735 0 1.365.117 1.891.351.531.235.938.557 1.219.969.286.406.43.87.43 1.39h-2.25c0-.218-.047-.413-.141-.585a.929.929 0 0 0-.422-.414c-.188-.105-.432-.157-.734-.157-.25 0-.466.045-.649.133a.995.995 0 0 0-.422.344.827.827 0 0 0-.14.469c0 .13.026.247.078.351.057.1.148.19.273.274.125.083.287.161.485.234.203.068.453.13.75.188.609.125 1.153.289 1.632.492.48.198.86.468 1.141.812.281.339.422.784.422 1.336 0 .375-.083.719-.25 1.031a2.488 2.488 0 0 1-.719.82c-.312.23-.687.41-1.125.54-.432.125-.92.187-1.46.187-.787 0-1.454-.14-2-.422-.542-.28-.954-.638-1.235-1.07-.276-.437-.414-.885-.414-1.344h2.133c.01.308.088.555.234.742.151.188.341.323.57.407.235.083.487.125.758.125.292 0 .534-.04.727-.117.192-.084.338-.193.437-.329a.792.792 0 0 0 .156-.484ZM50.492 9.664a.731.731 0 0 0-.14-.437c-.094-.13-.269-.25-.524-.36-.25-.114-.612-.219-1.086-.312a8.469 8.469 0 0 1-1.195-.352 4.145 4.145 0 0 1-.953-.523 2.275 2.275 0 0 1-.625-.72 1.998 1.998 0 0 1-.227-.96c0-.354.076-.688.227-1 .156-.313.377-.589.664-.828a3.142 3.142 0 0 1 1.062-.57c.422-.141.896-.211 1.422-.211.735 0 1.365.117 1.89.351.532.235.938.557 1.22.969.286.406.43.87.43 1.39h-2.25c0-.218-.048-.413-.141-.585a.928.928 0 0 0-.422-.414c-.188-.105-.433-.157-.735-.157-.25 0-.466.045-.648.133a.994.994 0 0 0-.422.344.826.826 0 0 0-.14.469c0 .13.026.247.078.351.057.1.148.19.273.274.125.083.286.161.484.234.203.068.453.13.75.188a8.63 8.63 0 0 1 1.633.492c.48.198.86.468 1.14.812.282.339.423.784.423 1.336 0 .375-.084.719-.25 1.031a2.49 2.49 0 0 1-.72.82c-.312.23-.687.41-1.124.54-.432.125-.92.187-1.461.187-.786 0-1.453-.14-2-.422-.542-.28-.953-.638-1.234-1.07-.276-.437-.414-.885-.414-1.344h2.132c.01.308.089.555.235.742.15.188.34.323.57.407.234.083.487.125.758.125.292 0 .534-.04.726-.117.193-.084.339-.193.438-.329a.792.792 0 0 0 .156-.484ZM56.666 3.547V12h-2.258V3.547h2.258Zm-2.399-2.203c0-.328.115-.6.344-.813.23-.213.536-.32.922-.32.38 0 .685.107.914.32.234.214.351.485.351.813 0 .328-.117.599-.351.812-.23.214-.534.32-.914.32-.386 0-.693-.106-.922-.32a1.063 1.063 0 0 1-.344-.812ZM58.675 0h2.25v10.063L60.698 12h-2.023V0Zm7.602 7.688v.164c0 .63-.068 1.208-.204 1.734-.13.526-.333.982-.609 1.367-.276.38-.62.677-1.031.89-.406.21-.886.313-1.438.313-.515 0-.963-.104-1.343-.312a2.73 2.73 0 0 1-.946-.883 5.016 5.016 0 0 1-.617-1.336 10.16 10.16 0 0 1-.352-1.672v-.36a10.16 10.16 0 0 1 .352-1.671c.156-.51.362-.956.617-1.336.255-.38.57-.675.946-.883.375-.208.817-.312 1.328-.312.557 0 1.041.106 1.453.32.416.208.76.505 1.031.89.276.38.48.834.61 1.36.135.52.203 1.096.203 1.726Zm-2.25.164v-.165c0-.343-.026-.666-.079-.968a2.56 2.56 0 0 0-.25-.805 1.414 1.414 0 0 0-.492-.555c-.203-.135-.466-.203-.789-.203a1.77 1.77 0 0 0-.781.157c-.214.104-.39.25-.531.437a1.991 1.991 0 0 0-.305.672c-.068.255-.11.536-.125.844v1.023c.016.412.083.776.203 1.094.125.312.313.56.563.742.255.177.586.266.992.266.318 0 .58-.063.789-.188a1.26 1.26 0 0 0 .484-.531c.12-.23.203-.498.25-.805.047-.312.07-.65.07-1.015ZM70.2 3.547V12h-2.258V3.547H70.2Zm-2.398-2.203c0-.328.114-.6.343-.813.23-.213.537-.32.922-.32.38 0 .685.107.914.32.235.214.352.485.352.813 0 .328-.117.599-.352.812-.229.214-.534.32-.914.32-.385 0-.692-.106-.922-.32a1.062 1.062 0 0 1-.343-.812ZM74.584 0v12h-2.257V0h2.257ZM78.969 3.547V12H76.71V3.547h2.258ZM76.57 1.344c0-.328.115-.6.344-.813.23-.213.537-.32.922-.32.38 0 .685.107.914.32.234.214.352.485.352.813 0 .328-.118.599-.352.812-.23.214-.534.32-.914.32-.385 0-.693-.106-.922-.32a1.062 1.062 0 0 1-.344-.812ZM85.119 3.547V5.14h-4.922V3.547h4.922ZM81.416 1.46h2.25v7.992c0 .245.03.432.093.563.068.13.167.221.297.273.13.047.294.07.492.07.141 0 .266-.005.375-.015.115-.016.211-.031.29-.047l.007 1.656a4.231 4.231 0 0 1-.625.149 4.643 4.643 0 0 1-.742.054c-.495 0-.927-.08-1.297-.242a1.786 1.786 0 0 1-.843-.797c-.198-.364-.297-.844-.297-1.437V1.46ZM89.058 11.047l2.242-7.5h2.414l-3.398 9.726a5.264 5.264 0 0 1-.297.688c-.12.245-.284.476-.492.695a2.302 2.302 0 0 1-.774.547c-.307.14-.685.211-1.133.211-.213 0-.388-.013-.523-.039a9.164 9.164 0 0 1-.484-.11v-1.648h.18c.062.005.122.008.179.008.297 0 .539-.034.726-.102.188-.067.339-.171.454-.312a1.5 1.5 0 0 0 .273-.531l.633-1.633Zm-.938-7.5 1.836 6.125.32 2.383-1.53.164-3.04-8.672h2.414Z"
				fill={strokeColor}
			/>
		</SvgIcon>
	);
}

export default AccessibilityTextIcon;
